/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectInput
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(AbstractSelectInput.class);

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        Boolean valid = actionCtx.getFormValid();
        if (valid != null && valid.booleanValue()) {
            return false;
        }
        ActionConfig actionConfig = actionCtx.getActionConfig();
        ModuleConfig moduleConfig = actionConfig.getModuleConfig();
        ForwardConfig forwardConfig = null;
        String input = actionConfig.getInput();
        if (moduleConfig.getControllerConfig().getInputForward()) {
            this.log.trace("Finding ForwardConfig for '{}'", (Object)input);
            forwardConfig = this.inputForward(actionConfig, moduleConfig, input);
            if (forwardConfig == null) {
                this.log.atError().log(() -> this.getErrorMessage(actionCtx, actionConfig));
            }
        } else {
            this.log.trace("Delegating to forward() for '{}'", (Object)input);
            forwardConfig = this.forward(actionCtx, moduleConfig, input);
        }
        this.log.debug("Forwarding back to {}", (Object)forwardConfig);
        actionCtx.setForwardConfig(forwardConfig);
        return false;
    }

    protected abstract ForwardConfig forward(ActionContext var1, ModuleConfig var2, String var3);

    protected abstract String getErrorMessage(ActionContext var1, ActionConfig var2);

    protected ForwardConfig inputForward(ActionConfig actionConfig, ModuleConfig moduleConfig, String input) {
        ForwardConfig forwardConfig;
        if (input != null) {
            forwardConfig = actionConfig.findForwardConfig(input);
            if (forwardConfig == null) {
                forwardConfig = moduleConfig.findForwardConfig(input);
            }
        } else {
            forwardConfig = actionConfig.findForwardConfig("input");
            if (forwardConfig == null) {
                forwardConfig = moduleConfig.findForwardConfig("input");
            }
        }
        return forwardConfig;
    }
}

