/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionHandler
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(AbstractExceptionHandler.class);

    @Override
    protected boolean execute_(ActionContext actionCtx) throws Exception {
        Exception exception = actionCtx.getException();
        if (exception == null) {
            this.log.warn("No Exception found in ActionContext");
            return true;
        }
        ExceptionConfig exceptionConfig = null;
        ActionConfig actionConfig = actionCtx.getActionConfig();
        ModuleConfig moduleConfig = actionCtx.getModuleConfig();
        if (actionConfig != null) {
            this.log.debug("See if actionConfig {} has an exceptionConfig for {}", (Object)actionConfig, (Object)exception.getClass().getName());
            exceptionConfig = actionConfig.findException(exception.getClass());
        } else if (moduleConfig != null) {
            this.log.debug("No action yet, see if moduleConfig {} has an exceptionConfig {}", (Object)moduleConfig, (Object)exception.getClass().getName());
            exceptionConfig = moduleConfig.findException(exception.getClass());
        }
        if (exceptionConfig == null) {
            this.log.warn("Unhandled exception", (Throwable)exception);
            throw exception;
        }
        ForwardConfig forwardConfig = this.handle(actionCtx, exception, exceptionConfig, actionConfig, moduleConfig);
        if (forwardConfig != null) {
            actionCtx.setForwardConfig(forwardConfig);
            return false;
        }
        return true;
    }

    protected abstract ForwardConfig handle(ActionContext var1, Exception var2, ExceptionConfig var3, ActionConfig var4, ModuleConfig var5) throws Exception;
}

