/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor
implements Serializable {
    private static final long serialVersionUID = -6430999735913386425L;
    public static final String INCLUDE_PATH_INFO = "jakarta.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "jakarta.servlet.include.servlet_path";
    private final transient Logger log = LoggerFactory.getLogger(RequestProcessor.class);
    protected HashMap<String, Action> actions = new HashMap();
    protected ModuleConfig moduleConfig = null;
    protected ActionServlet servlet = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashMap<String, Action> hashMap = this.actions;
        synchronized (hashMap) {
            for (Action action : this.actions.values()) {
                action.setServlet(null);
            }
            this.actions.clear();
        }
        this.servlet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        HashMap<String, Action> hashMap = this.actions;
        synchronized (hashMap) {
            this.actions.clear();
        }
        this.servlet = servlet;
        this.moduleConfig = moduleConfig;
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = this.processPath(request = this.processMultipart(request), response);
        if (path == null) {
            return;
        }
        this.log.debug("Processing a '{}' for path '{}'", (Object)request.getMethod(), (Object)path);
        this.processLocale(request, response);
        this.processContent(request, response);
        this.processNoCache(request, response);
        if (!this.processPreprocess(request, response)) {
            return;
        }
        this.processCachedMessages(request, response);
        ActionMapping mapping = this.processMapping(request, response, path);
        if (mapping == null) {
            return;
        }
        if (!this.processRoles(request, response, mapping)) {
            return;
        }
        ActionForm form = this.processActionForm(request, response, mapping);
        this.processPopulate(request, response, form, mapping);
        try {
            if (!this.processValidate(request, response, form, mapping)) {
                return;
            }
        }
        catch (InvalidCancelException e) {
            ActionForward forward = this.processException(request, response, e, form, mapping);
            this.processForwardConfig(request, response, forward);
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        if (!this.processForward(request, response, mapping)) {
            return;
        }
        if (!this.processInclude(request, response, mapping)) {
            return;
        }
        Action action = this.processActionCreate(request, response, mapping);
        if (action == null) {
            return;
        }
        ActionForward forward = this.processActionPerform(request, response, action, form, mapping);
        this.processForwardConfig(request, response, forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        Action instance;
        String className = mapping.getType();
        this.log.debug(" Looking for Action instance for class {}", (Object)className);
        HashMap<String, Action> hashMap = this.actions;
        synchronized (hashMap) {
            instance = this.actions.get(className);
            if (instance != null) {
                this.log.trace("  Returning existing Action instance");
                return instance;
            }
            this.log.trace("  Creating new Action instance");
            try {
                instance = (Action)RequestUtils.applicationInstance(className);
            }
            catch (Exception e) {
                this.log.atError().setMessage(() -> this.getInternal().getMessage("actionCreate", (Object)mapping.getPath(), (Object)mapping.toString())).setCause((Throwable)e).log();
                response.sendError(500, this.getInternal().getMessage("actionCreate", (Object)mapping.getPath()));
                return null;
            }
            this.actions.put(className, instance);
            if (instance.getServlet() == null) {
                instance.setServlet(this.servlet);
            }
        }
        return instance;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        ActionForm instance = RequestUtils.createActionForm(request, mapping, this.moduleConfig, this.servlet);
        if (instance == null) {
            return null;
        }
        this.log.debug(" Storing ActionForm bean instance in scope '{}' under attribute key '{}'", (Object)mapping.getScope(), (Object)mapping.getAttribute());
        if ("request".equals(mapping.getScope())) {
            request.setAttribute(mapping.getAttribute(), (Object)instance);
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(mapping.getAttribute(), (Object)instance);
        }
        return instance;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        this.log.debug("processForwardConfig({})", (Object)forward);
        String forwardPath = forward.getPath();
        String actionIdPath = RequestUtils.actionIdURL(forward, request, this.servlet);
        if (actionIdPath != null) {
            forwardPath = actionIdPath;
            ForwardConfig actionIdForward = new ForwardConfig(forward);
            actionIdForward.setPath(actionIdPath);
            forward = actionIdForward;
        }
        String uri = forwardPath.startsWith("/") ? RequestUtils.forwardURL(request, forward, null) : forwardPath;
        if (forward.getRedirect()) {
            if (uri.startsWith("/")) {
                uri = request.getContextPath() + uri;
            }
            response.sendRedirect(response.encodeRedirectURL(uri));
        } else {
            this.doForward(uri, request, response);
        }
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        try {
            return action.execute(mapping, form, request, response);
        }
        catch (Exception e) {
            return this.processException(request, response, e, form, mapping);
        }
    }

    protected void processCachedMessages(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        ActionMessages messages = (ActionMessages)session.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        if (messages != null && messages.isAccessed()) {
            session.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
        }
        if ((messages = (ActionMessages)session.getAttribute("org.apache.struts.action.ERROR")) != null && messages.isAccessed()) {
            session.removeAttribute("org.apache.struts.action.ERROR");
        }
    }

    protected void processContent(HttpServletRequest request, HttpServletResponse response) {
        String contentType = this.moduleConfig.getControllerConfig().getContentType();
        if (contentType != null) {
            response.setContentType(contentType);
        }
    }

    protected ActionForward processException(HttpServletRequest request, HttpServletResponse response, Exception exception, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        ExceptionConfig config = mapping.findException(exception.getClass());
        if (config == null) {
            this.log.atWarn().log(() -> this.getInternal().getMessage("unhandledException", exception.getClass()));
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            throw new ServletException((Throwable)exception);
        }
        try {
            ExceptionHandler handler = (ExceptionHandler)RequestUtils.applicationInstance(config.getHandler());
            return handler.execute(exception, config, mapping, form, request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String forward = mapping.getForward();
        if (forward == null) {
            return true;
        }
        String actionIdPath = RequestUtils.actionIdURL(forward, this.moduleConfig, this.servlet);
        if (actionIdPath != null) {
            forward = actionIdPath;
        }
        this.internalModuleRelativeForward(forward, request, response);
        return false;
    }

    protected boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String include = mapping.getInclude();
        if (include == null) {
            return true;
        }
        String actionIdPath = RequestUtils.actionIdURL(include, this.moduleConfig, this.servlet);
        if (actionIdPath != null) {
            include = actionIdPath;
        }
        this.internalModuleRelativeInclude(include, request, response);
        return false;
    }

    protected void processLocale(HttpServletRequest request, HttpServletResponse response) {
        if (!this.moduleConfig.getControllerConfig().getLocale()) {
            return;
        }
        HttpSession session = request.getSession();
        if (session.getAttribute("org.apache.struts.action.LOCALE") != null) {
            return;
        }
        Locale locale = request.getLocale();
        if (locale != null) {
            this.log.debug(" Setting user locale '{}'", (Object)locale);
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        }
    }

    protected ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        ActionMapping mapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        if (mapping != null) {
            request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
            return mapping;
        }
        ActionConfig[] configs = this.moduleConfig.findActionConfigs();
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getUnknown()) continue;
            mapping = (ActionMapping)configs[i];
            request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
            return mapping;
        }
        String msg = this.getInternal().getMessage("processInvalid");
        this.log.error("{} {}", (Object)msg, (Object)path);
        response.sendError(404, msg);
        return null;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return request;
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            return new MultipartRequestWrapper(request);
        }
        return request;
    }

    protected void processNoCache(HttpServletRequest request, HttpServletResponse response) {
        if (this.moduleConfig.getControllerConfig().getNocache()) {
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
            response.setDateHeader("Expires", 1L);
        }
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String prefix;
        String path;
        if (request.getAttribute("org.apache.struts.globals.ORIGINAL_URI_KEY") == null) {
            request.setAttribute("org.apache.struts.globals.ORIGINAL_URI_KEY", (Object)request.getServletPath());
        }
        if ((path = (String)request.getAttribute(INCLUDE_PATH_INFO)) == null) {
            path = request.getPathInfo();
        }
        if (path != null && path.length() > 0) {
            return path;
        }
        path = (String)request.getAttribute(INCLUDE_SERVLET_PATH);
        if (path == null) {
            path = request.getServletPath();
        }
        if (!path.startsWith(prefix = this.moduleConfig.getPrefix())) {
            String msg = this.getInternal().getMessage("processPath");
            this.log.error("{} {}", (Object)msg, (Object)request.getRequestURI());
            response.sendError(400, msg);
            return null;
        }
        path = path.substring(prefix.length());
        int slash = path.lastIndexOf("/");
        int period = path.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            path = path.substring(0, period);
        }
        return path;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        if (form == null) {
            return;
        }
        this.log.debug(" Populating bean properties from this request");
        form.setServlet(this.servlet);
        form.reset(mapping, request);
        if (mapping.getMultipartClass() != null) {
            request.setAttribute("org.apache.struts.action.mapping.multipartclass", (Object)mapping.getMultipartClass());
        }
        RequestUtils.populate(form, mapping.getPrefix(), mapping.getSuffix(), request);
        if (request.getParameter("org.apache.struts.taglib.html.CANCEL") != null || request.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null) {
            request.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String[] roles = mapping.getRoleNames();
        if (roles == null || roles.length < 1) {
            return true;
        }
        for (int i = 0; i < roles.length; ++i) {
            if (!request.isUserInRole(roles[i])) continue;
            this.log.debug(" User '{}' has role '{}', granting access", (Object)request.getRemoteUser(), (Object)roles[i]);
            return true;
        }
        this.log.debug(" User '{}' does not have any required role, denying access", (Object)request.getRemoteUser());
        response.sendError(403, this.getInternal().getMessage("notAuthorized", (Object)mapping.getPath()));
        return false;
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException, InvalidCancelException {
        String input;
        if (form == null) {
            return true;
        }
        if (!mapping.getValidate()) {
            return true;
        }
        if (request.getAttribute("org.apache.struts.action.CANCEL") != null) {
            if (mapping.getCancellable()) {
                this.log.debug(" Cancelled transaction, skipping validation");
                return true;
            }
            request.removeAttribute("org.apache.struts.action.CANCEL");
            throw new InvalidCancelException();
        }
        this.log.debug(" Validating input form properties");
        ActionErrors errors = form.validate(mapping, request);
        if (errors == null || errors.isEmpty()) {
            this.log.trace("  No errors detected, accepting input");
            return true;
        }
        if (form.getMultipartRequestHandler() != null) {
            this.log.trace("  Rolling back multipart request");
            form.getMultipartRequestHandler().rollback();
        }
        if ((input = mapping.getInput()) == null) {
            this.log.trace("  Validation failed but no input form available");
            response.sendError(500, this.getInternal().getMessage("noInput", (Object)mapping.getPath()));
            return false;
        }
        this.log.debug(" Validation failed, returning to '{}'", (Object)input);
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        if (this.moduleConfig.getControllerConfig().getInputForward()) {
            ActionForward forward = mapping.findForward(input);
            this.processForwardConfig(request, response, forward);
        } else {
            this.internalModuleRelativeForward(input, request, response);
        }
        return false;
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        uri = this.moduleConfig.getPrefix() + uri;
        this.log.debug(" Delegating via forward to '{}'", (Object)uri);
        this.doForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        uri = this.moduleConfig.getPrefix() + uri;
        this.log.debug(" Delegating via include to '{}'", (Object)uri);
        this.doInclude(uri, request, response);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(uri);
        if (rd == null) {
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(uri);
        if (rd == null) {
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        rd.include((ServletRequest)request, (ServletResponse)response);
    }

    protected MessageResources getInternal() {
        return this.servlet.getInternal();
    }

    protected ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }
}

