/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.struts.action.ActionMessage;

public class ActionMessages
implements Serializable {
    private static final long serialVersionUID = -4363118850236216381L;
    private static final Comparator<ActionMessageItem> ACTION_ITEM_COMPARATOR = (ami1, ami2) -> ami1.getOrder() - ami2.getOrder();
    public static final String GLOBAL_MESSAGE = "org.apache.struts.action.GLOBAL_MESSAGE";
    protected boolean accessed = false;
    protected HashMap<String, ActionMessageItem> messages = new HashMap();
    protected int iCount = 0;

    public ActionMessages() {
    }

    public ActionMessages(ActionMessages messages) {
        this.add(messages);
    }

    public void add(String property, ActionMessage message) {
        List<ActionMessage> list;
        ActionMessageItem item = this.messages.get(property);
        if (item == null) {
            list = new ArrayList<ActionMessage>();
            item = new ActionMessageItem(list, this.iCount++, property);
            this.messages.put(property, item);
        } else {
            list = item.getList();
        }
        list.add(message);
    }

    public void add(ActionMessages actionMessages) {
        if (actionMessages == null) {
            return;
        }
        Iterator<String> props = actionMessages.properties();
        while (props.hasNext()) {
            String property = props.next();
            Iterator<ActionMessage> msgs = actionMessages.get(property);
            while (msgs.hasNext()) {
                this.add(property, msgs.next());
            }
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public Iterator<ActionMessage> get() {
        this.accessed = true;
        if (this.messages.isEmpty()) {
            return Collections.emptyListIterator();
        }
        ActionMessageItem[] actionItems = this.messages.values().toArray(new ActionMessageItem[0]);
        Arrays.sort(actionItems, ACTION_ITEM_COMPARATOR);
        ArrayList<ActionMessage> results = new ArrayList<ActionMessage>();
        for (ActionMessageItem ami : actionItems) {
            results.addAll(ami.getList());
        }
        return results.iterator();
    }

    public Iterator<ActionMessage> get(String property) {
        this.accessed = true;
        ActionMessageItem item = this.messages.get(property);
        if (item == null) {
            return Collections.emptyListIterator();
        }
        return item.getList().iterator();
    }

    public boolean isAccessed() {
        return this.accessed;
    }

    public Iterator<String> properties() {
        if (this.messages.isEmpty()) {
            return Collections.emptyListIterator();
        }
        ActionMessageItem[] actionItems = this.messages.values().toArray(new ActionMessageItem[0]);
        Arrays.sort(actionItems, ACTION_ITEM_COMPARATOR);
        ArrayList<String> results = new ArrayList<String>(actionItems.length);
        for (ActionMessageItem ami : actionItems) {
            results.add(ami.getProperty());
        }
        return results.iterator();
    }

    public int size() {
        int total = 0;
        for (ActionMessageItem ami : this.messages.values()) {
            total += ami.getList().size();
        }
        return total;
    }

    public int size(String property) {
        ActionMessageItem item = this.messages.get(property);
        return item == null ? 0 : item.getList().size();
    }

    public String toString() {
        return this.messages.toString();
    }

    protected class ActionMessageItem
    implements Serializable {
        private static final long serialVersionUID = 6569527708054508739L;
        protected List<ActionMessage> list = null;
        protected int iOrder = 0;
        protected String property = null;

        public ActionMessageItem(List<ActionMessage> list, int iOrder, String property) {
            this.list = list;
            this.iOrder = iOrder;
            this.property = property;
        }

        public List<ActionMessage> getList() {
            return this.list;
        }

        public void setList(List<ActionMessage> list) {
            this.list = list;
        }

        public int getOrder() {
            return this.iOrder;
        }

        public void setOrder(int iOrder) {
            this.iOrder = iOrder;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String toString() {
            return this.list.toString();
        }
    }
}

