/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.util;

import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum Util {

    private static final double FLOATING_DELTA = 1.0E-12;
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(Charset.forName("UTF-8"));

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("The parameter bytes is null.");
        }
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, Charset.forName("UTF-8"));
    }

    public static byte[] hash(String method, byte[] data) {
        if (method == null) {
            throw new IllegalArgumentException("The parameter method is null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("The parameter data is null.");
        }
        try {
            return MessageDigest.getInstance(method).digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Hash method must be supported", e);
        }
    }

    public static int log2(int x) {
        Validations.requirePositiveNonZero(x, "Value");
        return Integer.bitCount(Integer.highestOneBit(x) - 1);
    }

    public static int readNBytes(InputStream stream, byte[] abBuf, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len && (count = stream.read(abBuf, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }
}

