/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public final class FlatIterator<X, Y>
implements Iterator<Y> {
    private final Iterator<? extends X> outerIterator;
    private final Function<? super X, ? extends Iterator<Y>> provider;
    private Iterator<Y> currentInnerIter;

    public FlatIterator(Iterator<? extends X> outerIterator, Function<? super X, ? extends Iterator<Y>> provider) {
        if (outerIterator == null) {
            throw new IllegalArgumentException("The parameter outerIterator is null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("The parameter provider is null.");
        }
        this.outerIterator = outerIterator;
        this.provider = provider;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            boolean hasNext;
            boolean bl = hasNext = this.currentInnerIter != null && this.currentInnerIter.hasNext();
            if (hasNext) {
                return true;
            }
            if (!this.outerIterator.hasNext()) {
                return false;
            }
            this.currentInnerIter = this.provider.apply(this.outerIterator.next());
        }
    }

    @Override
    public Y next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempting to get the next element but the iterator is out of elements");
        }
        return this.currentInnerIter.next();
    }
}

