/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.ChunkMetadata;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;

public final class SimpleChunkMetadata
implements ChunkMetadata {
    private final byte[] hash;
    private final String hexHash;
    private final int length;
    private final long offset;

    public SimpleChunkMetadata(long offset, int length, byte[] hash, String hexHash) {
        if (hash == null) {
            throw new NullPointerException("The parameter hash is null.");
        }
        Validations.require(hash.length > 0, "Hash must not be empty");
        if (hexHash == null) {
            throw new NullPointerException("The parameter hexHash is null.");
        }
        Validations.require(!hexHash.isEmpty(), "Hex hash must not be empty");
        this.offset = Validations.requirePositive(offset, "Offset");
        this.length = Validations.requirePositiveNonZero(length, "Length");
        this.hash = hash;
        this.hexHash = hexHash;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public String getHexHash() {
        return this.hexHash;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }
}

