/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.Chunk;
import io.github.zabuzard.fastcdc4j.internal.util.Util;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;

public final class SimpleChunk
implements Chunk {
    private final byte[] data;
    private final byte[] hash;
    private final String hexHash;
    private final long offset;

    public SimpleChunk(byte[] data, long offset, byte[] hash) {
        if (data == null) {
            throw new NullPointerException("The parameter data is null.");
        }
        Validations.require(data.length > 0, "Data must not be empty");
        if (hash == null) {
            throw new NullPointerException("The parameter hash is null.");
        }
        Validations.require(hash.length > 0, "Hash must not be empty");
        this.data = data;
        this.offset = Validations.requirePositive(offset, "Offset");
        this.hash = hash;
        this.hexHash = Util.bytesToHex(hash);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public byte[] getHash() {
        return this.hash;
    }

    @Override
    public String getHexHash() {
        return this.hexHash;
    }

    @Override
    public int getLength() {
        return this.data.length;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }
}

