/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.MaskOption;
import io.github.zabuzard.fastcdc4j.internal.util.Util;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MaskGenerator {
    private static final int MASK_SIZE_TOTAL_FAST_CDC = 48;
    private final int expectedChunkSize;
    private final MaskOption maskOption;
    private final int normalizationLevel;
    private final long seed;

    private static long generateMaskFastCdc(int effectiveBits, long seed) {
        int i;
        Validations.requirePositiveNonZero(effectiveBits, "Effective bits");
        ArrayList<Integer> maskBits = new ArrayList<Integer>();
        for (i = 0; i < effectiveBits - 1; ++i) {
            maskBits.add(1);
        }
        while (i < 47) {
            maskBits.add(0);
            ++i;
        }
        Collections.shuffle(maskBits, new Random(seed));
        String mask = Stream.concat(Stream.of(Integer.valueOf(1)), maskBits.stream()).map(Object::toString).collect(Collectors.joining());
        return Long.parseLong(mask, 2);
    }

    private static long generateMaskNlfiedlerRust(int effectiveBits) {
        Validations.requirePositiveNonZero(effectiveBits, "Effective bits");
        return Long.parseLong(MaskGenerator.repeat("1", effectiveBits), 2);
    }

    private static int getEffectiveBits(int expectedChunkSize) {
        Validations.requirePositiveNonZero(expectedChunkSize, "Expected chunk size");
        return Util.log2(expectedChunkSize);
    }

    public MaskGenerator(MaskOption maskOption, int normalizationLevel, int expectedChunkSize, long seed) {
        if (maskOption == null) {
            throw new IllegalArgumentException("The parameter maskOption is null.");
        }
        this.maskOption = maskOption;
        this.normalizationLevel = Validations.requirePositive(normalizationLevel, "Normalization level");
        this.expectedChunkSize = Validations.requirePositiveNonZero(expectedChunkSize, "Expected chunk size");
        this.seed = seed;
    }

    public long generateLargeMask() {
        return this.generateMask(-this.normalizationLevel);
    }

    public long generateSmallMask() {
        return this.generateMask(this.normalizationLevel);
    }

    private long generateMask(int effectiveBitOffset) {
        int effectiveBits = MaskGenerator.getEffectiveBits(this.expectedChunkSize) + effectiveBitOffset;
        long lMask = -1L;
        switch (this.maskOption) {
            case FAST_CDC: {
                lMask = MaskGenerator.generateMaskFastCdc(effectiveBits, this.seed);
                break;
            }
            case NLFIEDLER_RUST: {
                lMask = MaskGenerator.generateMaskNlfiedlerRust(effectiveBits);
            }
        }
        return lMask;
    }

    public static String repeat(String core, int count) {
        int copied;
        byte[] value = core.getBytes();
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return core;
        }
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Repeating " + len + " bytes String " + count + " times will produce a String exceeding maximum size.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple);
    }
}

