/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.Chunk;
import io.github.zabuzard.fastcdc4j.external.chunking.Chunker;
import io.github.zabuzard.fastcdc4j.external.chunking.IterativeStreamChunkerCore;
import io.github.zabuzard.fastcdc4j.internal.chunking.SimpleChunk;
import io.github.zabuzard.fastcdc4j.internal.util.Util;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IterativeStreamChunker
implements Chunker {
    private final IterativeStreamChunkerCore core;
    private final String hashMethod;

    public IterativeStreamChunker(IterativeStreamChunkerCore core, String hashMethod) {
        if (hashMethod == null) {
            throw new NullPointerException("The parameter hashMethod is null.");
        }
        try {
            MessageDigest.getInstance(hashMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("The given hash method is not supported, was: " + hashMethod, e);
        }
        if (core == null) {
            throw new NullPointerException("The parameter IterativeStreamChunkerCore is null.");
        }
        this.core = core;
        this.hashMethod = hashMethod;
    }

    @Override
    public Iterable<Chunk> chunk(final InputStream stream, final long size) {
        if (stream == null) {
            throw new NullPointerException("The parameter stream is null.");
        }
        Validations.requirePositiveNonZero(size, "Size");
        return new Iterable<Chunk>(){

            @Override
            public Iterator<Chunk> iterator() {
                return new ChunkerIterator(stream, size, IterativeStreamChunker.this.core, IterativeStreamChunker.this.hashMethod);
            }
        };
    }

    private static final class ChunkerIterator
    implements Iterator<Chunk> {
        private final IterativeStreamChunkerCore core;
        private final String hashMethod;
        private final long size;
        private final InputStream stream;
        private long currentOffset;

        private ChunkerIterator(InputStream stream, long size, IterativeStreamChunkerCore core, String hashMethod) {
            if (hashMethod == null) {
                throw new NullPointerException("The parameter hashMethod is null.");
            }
            try {
                MessageDigest.getInstance(hashMethod);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("The given hash method is not supported, was: " + hashMethod, e);
            }
            if (stream == null) {
                throw new NullPointerException("The parameter InputStream is null.");
            }
            this.stream = stream;
            this.size = Validations.requirePositiveNonZero(size, "Size");
            if (core == null) {
                throw new NullPointerException("The parameter IterativeStreamChunkerCore is null.");
            }
            this.core = core;
            this.hashMethod = hashMethod;
        }

        @Override
        public boolean hasNext() {
            return this.currentOffset < this.size;
        }

        @Override
        public Chunk next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The data stream has ended, can not generate another chunk");
            }
            byte[] data = this.core.readNextChunk(this.stream, this.size, this.currentOffset);
            SimpleChunk chunk = new SimpleChunk(data, this.currentOffset, Util.hash(this.hashMethod, data));
            this.currentOffset += (long)data.length;
            return chunk;
        }

        @Override
        public void remove() {
        }
    }
}

