/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.IterativeStreamChunkerCore;
import io.github.zabuzard.fastcdc4j.internal.util.Util;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public final class FixedSizeChunkerCore
implements IterativeStreamChunkerCore {
    private final int chunkSize;

    public FixedSizeChunkerCore(int chunkSize) {
        this.chunkSize = Validations.requirePositiveNonZero(chunkSize, "Chunk size");
    }

    @Override
    public byte[] readNextChunk(InputStream stream, long size, long currentOffset) {
        if (stream == null) {
            throw new NullPointerException("The parameter InputStream is null.");
        }
        Validations.requirePositiveNonZero(size, "Size");
        Validations.requirePositive(currentOffset, "Current offset");
        Validations.require(currentOffset < size, "Current offset must be less than size");
        int length = currentOffset + (long)this.chunkSize <= size ? this.chunkSize : (int)(size - currentOffset);
        try {
            byte[] chunk = new byte[]{};
            Util.readNBytes(stream, chunk, (int)currentOffset, length);
            return chunk;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int readNextChunk(InputStream stream, byte[] abBuf, int iOffset, long currentOffset) {
        return 0;
    }
}

