/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.IterativeStreamChunkerCore;
import io.github.zabuzard.fastcdc4j.internal.util.Util;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;

public final class FastCdcChunkerCore
implements IterativeStreamChunkerCore {
    private final int expectedSize;
    private final long[] gear;
    private final long maskLarge;
    private final long maskSmall;
    private final int maxSize;
    private final int minSize;

    public FastCdcChunkerCore(int expectedSize, int minSize, int maxSize, long[] gear, long maskSmall, long maskLarge) {
        Validations.require(minSize <= expectedSize, "Min size must be less equals expected size");
        Validations.require(maxSize >= expectedSize, "Max size must be greater equals expected size");
        Objects.requireNonNull(gear);
        Validations.require(gear.length == 256, "Gear must have a length of 256, one hash per byte value, was: " + gear.length);
        this.expectedSize = Validations.requirePositive(expectedSize, "Expected size");
        this.minSize = Validations.requirePositive(minSize, "Min size");
        this.maxSize = Validations.requirePositive(maxSize, "Max size");
        this.gear = (long[])gear.clone();
        this.maskSmall = maskSmall;
        this.maskLarge = maskLarge;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] readNextChunk(InputStream stream, long size, long currentOffset) {
        int data;
        int i;
        long fingerprint;
        long n;
        Throwable throwable;
        ByteArrayOutputStream dataBuffer;
        Objects.requireNonNull(stream);
        Validations.requirePositiveNonZero(size, "Size");
        Validations.requirePositive(currentOffset, "Current offset");
        Validations.require(currentOffset < size, "Current offset must be less than size");
        try {
            dataBuffer = new ByteArrayOutputStream();
            throwable = null;
            try {
                byte[] bTempByte = new byte[]{};
                int normalSize = this.expectedSize;
                n = size - currentOffset;
                if (n <= 0L) {
                    throw new IllegalArgumentException("Attempting to read the next chunk but out of available bytes, as indicated by size");
                }
                if (n <= (long)this.minSize) {
                    Util.readNBytes(stream, bTempByte, (int)currentOffset, (int)n);
                    byte[] byArray = bTempByte;
                    return byArray;
                }
                if (n >= (long)this.maxSize) {
                    n = this.maxSize;
                } else if (n <= (long)normalSize) {
                    normalSize = (int)n;
                }
                fingerprint = 0L;
                Util.readNBytes(stream, bTempByte, (int)currentOffset, i);
                dataBuffer.write(bTempByte);
                for (i = this.minSize; i < normalSize; ++i) {
                    data = stream.read();
                    if (data == -1) {
                        throw new IllegalStateException("Attempting to read a byte from the stream but the stream has ended");
                    }
                    dataBuffer.write(data);
                    fingerprint = (fingerprint << 1) + this.gear[data];
                    if ((fingerprint & this.maskSmall) != 0L) continue;
                    byte[] byArray = dataBuffer.toByteArray();
                    return byArray;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        while ((long)i < n) {
            data = stream.read();
            if (data == -1) {
                throw new IllegalStateException("Attempting to read a byte from the stream but the stream has ended");
            }
            dataBuffer.write(data);
            fingerprint = (fingerprint << 1) + this.gear[data];
            if ((fingerprint & this.maskLarge) == 0L) {
                return dataBuffer.toByteArray();
            }
            ++i;
        }
        return dataBuffer.toByteArray();
        finally {
            if (dataBuffer != null) {
                if (throwable != null) {
                    try {
                        dataBuffer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    dataBuffer.close();
                }
            }
        }
    }

    @Override
    public int readNextChunk(InputStream stream, byte[] abBuf, int iOffset, long currentOffset) throws IOException {
        int data;
        Objects.requireNonNull(stream);
        Validations.requirePositive(currentOffset, "Current offset");
        int iTotalRead = 0;
        int iMinSizeRead = Util.readNBytes(stream, abBuf, iOffset, this.minSize);
        if (iMinSizeRead == 0) {
            return -1;
        }
        if (iMinSizeRead < this.minSize) {
            return iMinSizeRead;
        }
        iTotalRead += iMinSizeRead;
        iOffset += iMinSizeRead;
        long fingerprint = 0L;
        while (iTotalRead < this.expectedSize) {
            data = stream.read();
            if (data == -1) {
                return iTotalRead;
            }
            abBuf[iOffset] = (byte)data;
            ++iTotalRead;
            ++iOffset;
            if (((fingerprint = (fingerprint << 1) + this.gear[data]) & this.maskSmall) != 0L) continue;
            return iTotalRead;
        }
        while (iTotalRead < this.maxSize) {
            data = stream.read();
            if (data == -1) {
                return iTotalRead;
            }
            abBuf[iOffset] = (byte)data;
            ++iTotalRead;
            ++iOffset;
            if (((fingerprint = (fingerprint << 1) + this.gear[data]) & this.maskLarge) != 0L) continue;
            return iTotalRead;
        }
        return iTotalRead;
    }
}

