/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.VMInsightsClient;
import com.azure.resourcemanager.monitor.fluent.models.VMInsightsOnboardingStatusInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import reactor.core.publisher.Mono;

public final class VMInsightsClientImpl
implements VMInsightsClient {
    private final ClientLogger logger = new ClientLogger(VMInsightsClientImpl.class);
    private final VMInsightsService service;
    private final MonitorClientImpl client;

    VMInsightsClientImpl(MonitorClientImpl client) {
        this.service = (VMInsightsService)RestProxy.create(VMInsightsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VMInsightsOnboardingStatusInner>> getOnboardingStatusWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-11-27-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOnboardingStatus(this.client.getEndpoint(), "2018-11-27-preview", resourceUri, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VMInsightsOnboardingStatusInner>> getOnboardingStatusWithResponseAsync(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-11-27-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getOnboardingStatus(this.client.getEndpoint(), "2018-11-27-preview", resourceUri, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VMInsightsOnboardingStatusInner> getOnboardingStatusAsync(String resourceUri) {
        return this.getOnboardingStatusWithResponseAsync(resourceUri).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VMInsightsOnboardingStatusInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VMInsightsOnboardingStatusInner getOnboardingStatus(String resourceUri) {
        return (VMInsightsOnboardingStatusInner)((Object)this.getOnboardingStatusAsync(resourceUri).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VMInsightsOnboardingStatusInner> getOnboardingStatusWithResponse(String resourceUri, Context context) {
        return (Response)this.getOnboardingStatusWithResponseAsync(resourceUri, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientVMInsig")
    private static interface VMInsightsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/vmInsightsOnboardingStatuses/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VMInsightsOnboardingStatusInner>> getOnboardingStatus(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

