/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.RuleAction;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class AlertRuleResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AlertRuleResourceInner.class);
    @JsonProperty(value="properties.name", required=true)
    private String namePropertiesName;
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.provisioningState")
    private String provisioningState;
    @JsonProperty(value="properties.isEnabled", required=true)
    private boolean isEnabled;
    @JsonProperty(value="properties.condition", required=true)
    private RuleCondition condition;
    @JsonProperty(value="properties.action")
    private RuleAction action;
    @JsonProperty(value="properties.actions")
    private List<RuleAction> actions;
    @JsonProperty(value="properties.lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;

    public String namePropertiesName() {
        return this.namePropertiesName;
    }

    public AlertRuleResourceInner withNamePropertiesName(String namePropertiesName) {
        this.namePropertiesName = namePropertiesName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertRuleResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public AlertRuleResourceInner withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public AlertRuleResourceInner withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public RuleCondition condition() {
        return this.condition;
    }

    public AlertRuleResourceInner withCondition(RuleCondition condition) {
        this.condition = condition;
        return this;
    }

    public RuleAction action() {
        return this.action;
    }

    public AlertRuleResourceInner withAction(RuleAction action) {
        this.action = action;
        return this;
    }

    public List<RuleAction> actions() {
        return this.actions;
    }

    public AlertRuleResourceInner withActions(List<RuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public AlertRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AlertRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.namePropertiesName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property namePropertiesName in model AlertRuleResourceInner"));
        }
        if (this.condition() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property condition in model AlertRuleResourceInner"));
        }
        this.condition().validate();
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

