/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.scripting;

import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.struts.scripting.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Script {
    private final Logger log = LoggerFactory.getLogger(Script.class);
    public final String name;
    public final Path path;
    public final ScriptEngine scriptEngine;
    public final boolean compilable;
    public FileTime lastModifiedTime;
    public String content;
    public CompiledScript compiledScript;
    private IOException ioe;
    private ScriptException se;

    public Script(ScriptEngineManager scriptEngineManager, ServletContext context, String name) {
        this.name = name;
        int i = name.lastIndexOf(46);
        String ext = i < 0 ? name : name.substring(i + 1);
        this.scriptEngine = scriptEngineManager.getEngineByExtension(ext);
        if (this.scriptEngine == null) {
            this.se = new ScriptException("No ScriptEngine found for file: " + name);
        }
        this.compilable = this.scriptEngine instanceof Compilable;
        String realPath = context.getRealPath(name);
        this.path = realPath == null ? null : Paths.get(realPath, new String[0]);
        try (InputStream inputStream = realPath == null ? context.getResourceAsStream(name) : null;){
            if (this.path == null && inputStream == null) {
                this.se = new ScriptException("Could not find resource for file: " + name);
            }
            if (this.se != null) {
                return;
            }
            try (Reader r = this.path == null ? new InputStreamReader(inputStream, StandardCharsets.UTF_8) : Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
                this.lastModifiedTime = this.path != null ? IOUtils.getLastModifiedTime(this.path) : null;
                this.log.debug("Loading new script: {}", (Object)name);
                this.setContent(IOUtils.getStringFromReader(r));
            }
        }
        catch (IOException e) {
            this.ioe = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkNewContent() {
        this.ioe = null;
        if (this.path == null) {
            return false;
        }
        try {
            FileTime lastModifiedTime = IOUtils.getLastModifiedTime(this.path);
            if (this.lastModifiedTime != null && this.lastModifiedTime.compareTo(lastModifiedTime) >= 0) {
                return false;
            }
            Script script = this;
            synchronized (script) {
                this.log.debug("Loading updated script: {}", (Object)this.name);
                this.lastModifiedTime = lastModifiedTime;
                try (BufferedReader r = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
                    this.setContent(IOUtils.getStringFromReader(r));
                }
            }
        }
        catch (IOException e) {
            this.ioe = e;
        }
        return true;
    }

    public Bindings getBindings() {
        Bindings bindings = this.scriptEngine.getBindings(100);
        bindings.clear();
        bindings.put("javax.script.filename", (Object)this.name);
        return bindings;
    }

    public void checkExceptions() throws ScriptException, IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
        if (this.se != null) {
            throw this.se;
        }
    }

    public Object eval() throws ScriptException {
        if (this.compilable) {
            if (this.compiledScript == null) {
                throw this.se == null ? new ScriptException("Script could not compiled") : this.se;
            }
            return this.compiledScript.eval();
        }
        if (this.content == null || this.content.isEmpty()) {
            throw this.se == null ? new ScriptException("Script could not compiled") : this.se;
        }
        return this.scriptEngine.eval(this.content);
    }

    private void setContent(String content) {
        this.se = null;
        this.compiledScript = null;
        if (content == null || content.isEmpty()) {
            this.content = "";
        } else if (this.compilable) {
            this.content = null;
            try {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(content);
            }
            catch (ScriptException e) {
                this.se = e;
            }
        } else {
            this.content = content;
        }
    }
}

