/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested.logic;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import java.util.Map;
import org.apache.struts.taglib.logic.IterateTag;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedPropertyHelper;

public class NestedIterateTag
extends IterateTag
implements NestedNameSupport {
    private static final long serialVersionUID = -8879469068532412076L;
    private String nesting = null;
    private String originalName = null;
    private String originalProperty = null;
    private String originalNesting = null;
    private String originalNestingName = null;

    @Override
    public int doStartTag() throws JspException {
        this.originalName = this.getName();
        this.originalProperty = this.getProperty();
        if (this.id == null || this.id.trim().length() == 0) {
            this.id = this.property;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.originalNesting = NestedPropertyHelper.getCurrentProperty(request);
        this.originalNestingName = NestedPropertyHelper.getCurrentName(request, this);
        this.nesting = this.getName() == null ? NestedPropertyHelper.getAdjustedProperty(request, this.getProperty()) : this.getProperty();
        NestedPropertyHelper.setNestedProperties(request, this);
        int temp = super.doStartTag();
        NestedPropertyHelper.setName(request, this.getName());
        NestedPropertyHelper.setProperty(request, this.deriveNestedProperty());
        return temp;
    }

    private String deriveNestedProperty() {
        Object idObj = this.pageContext.getAttribute(this.id);
        if (idObj instanceof Map.Entry) {
            return this.nesting + "(" + ((Map.Entry)idObj).getKey() + ")";
        }
        return this.nesting + "[" + this.getIndex() + "]";
    }

    @Override
    public int doAfterBody() throws JspException {
        int temp = super.doAfterBody();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (temp != 0) {
            NestedPropertyHelper.setProperty(request, this.deriveNestedProperty());
        }
        return temp;
    }

    @Override
    public int doEndTag() throws JspException {
        int i = super.doEndTag();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        super.setName(this.originalName);
        super.setProperty(this.originalProperty);
        if (this.originalNesting == null) {
            NestedPropertyHelper.deleteReference(request);
        } else {
            NestedPropertyHelper.setProperty(request, this.originalNesting);
            NestedPropertyHelper.setName(request, this.originalNestingName);
        }
        return i;
    }

    @Override
    public void release() {
        super.release();
        this.originalName = null;
        this.originalProperty = null;
        this.originalNesting = null;
        this.originalNestingName = null;
    }
}

