/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.util.Iterator;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class MessagesTag
extends BodyTagSupport {
    private static final long serialVersionUID = -7665117721919199746L;
    protected static MessageResources messageResources = MessageResources.getMessageResources((String)"org.apache.struts.taglib.html.LocalStrings");
    protected Iterator<ActionMessage> iterator = null;
    protected boolean processed = false;
    protected String id = null;
    protected String bundle = null;
    protected String locale = "org.apache.struts.action.LOCALE";
    protected String name = "org.apache.struts.action.ERROR";
    protected String property = null;
    protected String header = null;
    protected String footer = null;
    protected String message = null;
    protected String count;
    protected boolean filterArgs = false;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean getFilterArgs() {
        return this.filterArgs;
    }

    public void setFilterArgs(boolean filterArgs) {
        this.filterArgs = filterArgs;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getCount() {
        return this.count;
    }

    public int doStartTag() throws JspException {
        String headerMessage;
        int size;
        this.processed = false;
        ActionMessages messages = null;
        String name = this.name;
        if (this.message != null && "true".equalsIgnoreCase(this.message)) {
            name = "org.apache.struts.action.ACTION_MESSAGE";
        }
        try {
            messages = TagUtils.getInstance().getActionMessages(this.pageContext, name);
        }
        catch (JspException e) {
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        if (this.property == null) {
            this.iterator = messages.get();
            size = messages.size();
        } else {
            this.iterator = messages.get(this.property);
            size = messages.size(this.property);
        }
        if (this.count != null) {
            this.pageContext.setAttribute(this.count, (Object)size);
        }
        if (!this.iterator.hasNext()) {
            return 0;
        }
        this.processMessage(this.iterator.next());
        if (this.header != null && this.header.length() > 0 && (headerMessage = TagUtils.getInstance().message(this.pageContext, this.bundle, this.locale, this.header)) != null) {
            TagUtils.getInstance().write(this.pageContext, headerMessage);
        }
        this.processed = true;
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            TagUtils.getInstance().writePrevious(this.pageContext, this.bodyContent.getString());
            this.bodyContent.clearBody();
        }
        if (this.iterator.hasNext()) {
            this.processMessage(this.iterator.next());
            return 2;
        }
        return 0;
    }

    private void processMessage(ActionMessage report) throws JspException {
        String msg = null;
        if (report.isResource()) {
            Object[] values = report.getValues();
            if (this.filterArgs) {
                values = this.filterMessageReplacementValues(values);
            }
            if ((msg = TagUtils.getInstance().message(this.pageContext, this.bundle, this.locale, report.getKey(), values)) == null) {
                String bundleName = this.bundle == null ? "default" : this.bundle;
                msg = messageResources.getMessage("messagesTag.notfound", (Object)report.getKey(), (Object)bundleName);
            }
        } else {
            msg = report.getKey();
        }
        if (msg == null) {
            this.pageContext.removeAttribute(this.id);
        } else {
            this.pageContext.setAttribute(this.id, (Object)msg);
        }
    }

    private Object[] filterMessageReplacementValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Object[] filteredArgs = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            filteredArgs[i] = values[i] instanceof String ? TagUtils.getInstance().filter((String)values[i]) : values[i];
        }
        return filteredArgs;
    }

    public int doEndTag() throws JspException {
        String footerMessage;
        if (this.processed && this.footer != null && this.footer.length() > 0 && (footerMessage = TagUtils.getInstance().message(this.pageContext, this.bundle, this.locale, this.footer)) != null) {
            TagUtils.getInstance().write(this.pageContext, footerMessage);
        }
        if (this.count != null) {
            this.pageContext.removeAttribute(this.count);
        }
        return 6;
    }

    public void release() {
        super.release();
        this.iterator = null;
        this.processed = false;
        this.id = null;
        this.bundle = null;
        this.locale = "org.apache.struts.action.LOCALE";
        this.name = "org.apache.struts.action.ERROR";
        this.property = null;
        this.header = null;
        this.footer = null;
        this.message = null;
        this.filterArgs = false;
        this.count = null;
    }
}

