/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum VCardDateFormat {
    EXTENDED{

        @Override
        String getPattern(TemporalAccessor temporal) {
            if (temporal instanceof ZoneOffset) {
                return "xxx";
            }
            if (temporal instanceof Instant) {
                return "yyyy-MM-dd'T'HH:mm:ssX";
            }
            if (VCardDateFormat.hasOffset(temporal)) {
                return "yyyy-MM-dd'T'HH:mm:ssxxx";
            }
            if (1.hasTime(temporal)) {
                return "yyyy-MM-dd'T'HH:mm:ss";
            }
            return "yyyy-MM-dd";
        }
    }
    ,
    BASIC{

        @Override
        String getPattern(TemporalAccessor temporal) {
            if (temporal instanceof ZoneOffset) {
                return "xx";
            }
            if (temporal instanceof Instant) {
                return "yyyyMMdd'T'HHmmssX";
            }
            if (VCardDateFormat.hasOffset(temporal)) {
                return "yyyyMMdd'T'HHmmssxx";
            }
            if (2.hasTime(temporal)) {
                return "yyyyMMdd'T'HHmmss";
            }
            return "yyyyMMdd";
        }
    };


    public String format(TemporalAccessor temporalAccessor) {
        String pattern = this.getPattern(temporalAccessor);
        DateTimeFormatter df = DateTimeFormatter.ofPattern(pattern, Locale.ROOT);
        if (temporalAccessor instanceof Instant) {
            temporalAccessor = ((Instant)temporalAccessor).atOffset(ZoneOffset.UTC);
        }
        return df.format(temporalAccessor);
    }

    abstract String getPattern(TemporalAccessor var1);

    public static Temporal parse(String string) {
        TimestampPattern p = TimestampPattern.parse(string);
        if (p == null) {
            throw Messages.INSTANCE.getIllegalArgumentException(41, string);
        }
        try {
            LocalDate date = LocalDate.of(p.year(), p.month(), p.date());
            if (!p.hasTime()) {
                return date;
            }
            LocalTime time = LocalTime.of(p.hour(), p.minute(), p.second(), p.nanosecond());
            LocalDateTime datetime = LocalDateTime.of(date, time);
            ZoneOffset offset = p.offset();
            if (offset == null) {
                return datetime;
            }
            OffsetDateTime offsetDateTime = OffsetDateTime.of(datetime, offset);
            return "Z".equals(offset.getId()) ? Instant.from(offsetDateTime) : offsetDateTime;
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean hasTime(TemporalAccessor temporalAccessor) {
        return temporalAccessor instanceof Instant || temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY);
    }

    private static boolean hasOffset(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS);
    }

    private static class TimestampPattern {
        private static final Pattern regex = Pattern.compile("^(\\d{4})(-?(\\d{2})-?(\\d{2})|-(\\d{1,2})-(\\d{1,2}))(T(\\d{2}):?(\\d{2}):?(\\d{2})(\\.\\d+)?(Z|([-+])((\\d{2})|((\\d{2}):?(\\d{2}))))?)?$");
        private final Matcher matcher;

        private TimestampPattern(Matcher matcher) {
            this.matcher = matcher;
        }

        public static TimestampPattern parse(String string) {
            Matcher m = regex.matcher(string);
            return m.find() ? new TimestampPattern(m) : null;
        }

        public int year() {
            return this.parseInt(1);
        }

        public int month() {
            return this.parseInt(3, 5);
        }

        public int date() {
            return this.parseInt(4, 6);
        }

        public boolean hasTime() {
            return this.matcher.group(8) != null;
        }

        public int hour() {
            return this.parseInt(8);
        }

        public int minute() {
            return this.parseInt(9);
        }

        public int second() {
            return this.parseInt(10);
        }

        public int nanosecond() {
            String s = this.matcher.group(11);
            if (s == null) {
                return 0;
            }
            double nanos = Double.parseDouble(s) * (double)TimeUnit.SECONDS.toNanos(1L);
            return (int)Math.round(nanos);
        }

        public ZoneOffset offset() {
            String offsetStr = this.matcher.group(12);
            return offsetStr == null ? null : ZoneOffset.of(offsetStr);
        }

        private int parseInt(int ... group) {
            for (int g : group) {
                String s = this.matcher.group(g);
                if (s == null) continue;
                return Integer.parseInt(s);
            }
            throw new NullPointerException();
        }
    }
}

