/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.KeyType;
import ezvcard.property.BinaryProperty;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class Key
extends BinaryProperty<KeyType> {
    private String text;

    public Key() {
    }

    public Key(byte[] data, KeyType type) {
        super(data, type);
    }

    public Key(String url, KeyType type) {
        super(url, type);
    }

    public Key(InputStream in, KeyType type) throws IOException {
        super(in, type);
    }

    public Key(Path file, KeyType type) throws IOException {
        super(file, type);
    }

    public Key(Key original) {
        super(original);
        this.text = original.text;
    }

    public void setText(String text, KeyType type) {
        this.text = text;
        this.data = null;
        this.url = null;
        this.setContentType(type);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void setUrl(String url, KeyType type) {
        super.setUrl(url, type);
        this.text = null;
    }

    @Override
    public String getUrl() {
        return super.getUrl();
    }

    @Override
    public void setData(byte[] data, KeyType type) {
        super.setData(data, type);
        this.text = null;
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.url == null && this.data == null && this.text == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
        if (this.url != null && (version == VCardVersion.V2_1 || version == VCardVersion.V3_0)) {
            warnings.add(new ValidationWarning(15, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        Map<String, Object> values = super.toStringValues();
        values.put("text", this.text);
        return values;
    }

    @Override
    public Key copy() {
        return new Key(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Key other = (Key)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

