/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.Pid;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.GeoUri;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Geo
extends VCardProperty
implements HasAltId {
    private GeoUri uri;

    public Geo(Double latitude, Double longitude) {
        this(new GeoUri.Builder(latitude, longitude).build());
    }

    public Geo(GeoUri uri) {
        this.uri = uri;
    }

    public Geo(Geo original) {
        super(original);
        this.uri = original.uri;
    }

    public Double getLatitude() {
        return this.uri == null ? null : this.uri.getCoordA();
    }

    public void setLatitude(Double latitude) {
        this.uri = this.uri == null ? new GeoUri.Builder(latitude, null).build() : new GeoUri.Builder(this.uri).coordA(latitude).build();
    }

    public Double getLongitude() {
        return this.uri == null ? null : this.uri.getCoordB();
    }

    public void setLongitude(Double longitude) {
        this.uri = this.uri == null ? new GeoUri.Builder(null, longitude).build() : new GeoUri.Builder(this.uri).coordB(longitude).build();
    }

    public GeoUri getGeoUri() {
        return this.uri;
    }

    public void setGeoUri(GeoUri uri) {
        this.uri = uri;
    }

    public String getType() {
        return this.parameters.getType();
    }

    public void setType(String type) {
        this.parameters.setType(type);
    }

    public String getMediaType() {
        return this.parameters.getMediaType();
    }

    public void setMediaType(String mediaType) {
        this.parameters.setMediaType(mediaType);
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.getLatitude() == null) {
            warnings.add(new ValidationWarning(13, new Object[0]));
        }
        if (this.getLongitude() == null) {
            warnings.add(new ValidationWarning(14, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("uri", this.uri);
        return values;
    }

    @Override
    public Geo copy() {
        return new Geo(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Geo other = (Geo)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

