/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.xml;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.util.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XCardElement {
    private final Document document;
    private final Element element;
    private final VCardVersion version;
    private final String namespace;

    public XCardElement(Element element) {
        this(element, VCardVersion.V4_0);
    }

    public XCardElement(Element element, VCardVersion version) {
        this.document = element.getOwnerDocument();
        this.element = element;
        this.version = version;
        this.namespace = version.getXmlNamespace();
    }

    public String first(VCardDataType ... dataTypes) {
        String[] names = new String[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            VCardDataType dataType = dataTypes[i];
            names[i] = XCardElement.toLocalName(dataType);
        }
        return this.first(names);
    }

    public String first(String ... names) {
        List<String> localNamesList = Arrays.asList(names);
        for (Element child : this.children()) {
            if (!localNamesList.contains(child.getLocalName()) || !this.namespace.equals(child.getNamespaceURI())) continue;
            return child.getTextContent();
        }
        return null;
    }

    public List<String> all(VCardDataType dataType) {
        String dataTypeStr = XCardElement.toLocalName(dataType);
        return this.all(dataTypeStr);
    }

    public List<String> all(String localName) {
        ArrayList<String> childrenText = new ArrayList<String>();
        for (Element child : this.children()) {
            String text;
            if (!localName.equals(child.getLocalName()) || !this.namespace.equals(child.getNamespaceURI()) || (text = child.getTextContent()).length() <= 0) continue;
            childrenText.add(child.getTextContent());
        }
        return childrenText;
    }

    public Element append(VCardDataType dataType, String value) {
        String dataTypeStr = XCardElement.toLocalName(dataType);
        return this.append(dataTypeStr, value);
    }

    public Element append(String name, String value) {
        Element child = this.document.createElementNS(this.namespace, name);
        child.setTextContent(value);
        this.element.appendChild(child);
        return child;
    }

    public List<Element> append(String name, Collection<String> values) {
        if (values.isEmpty()) {
            Element element = this.append(name, (String)null);
            return Collections.singletonList(element);
        }
        ArrayList<Element> elements = new ArrayList<Element>(values.size());
        for (String value : values) {
            elements.add(this.append(name, value));
        }
        return elements;
    }

    public Document document() {
        return this.document;
    }

    public Element element() {
        return this.element;
    }

    public VCardVersion version() {
        return this.version;
    }

    private List<Element> children() {
        return XmlUtils.toElementList(this.element.getChildNodes());
    }

    public XCardValue firstValue() {
        String elementNamespace = this.version.getXmlNamespace();
        for (Element child : this.children()) {
            String childNamespace = child.getNamespaceURI();
            if (!elementNamespace.equals(childNamespace)) continue;
            VCardDataType dataType = XCardElement.toDataType(child.getLocalName());
            String value = child.getTextContent();
            return new XCardValue(dataType, value);
        }
        return new XCardValue(null, this.element.getTextContent());
    }

    private static String toLocalName(VCardDataType dataType) {
        return dataType == null ? "unknown" : dataType.getName().toLowerCase();
    }

    private static VCardDataType toDataType(String localName) {
        return "unknown".equals(localName) ? null : VCardDataType.get(localName);
    }

    public static class XCardValue {
        private final VCardDataType dataType;
        private final String value;

        public XCardValue(VCardDataType dataType, String value) {
            this.dataType = dataType;
            this.value = value;
        }

        public VCardDataType getDataType() {
            return this.dataType;
        }

        public String getValue() {
            return this.value;
        }
    }
}

