/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.json.JsonValue;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.util.VCardDateFormat;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class VCardPropertyScribe<T extends VCardProperty> {
    protected final Class<T> clazz;
    protected final String propertyName;
    protected final QName qname;

    public VCardPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, new QName(VCardVersion.V4_0.getXmlNamespace(), propertyName.toLowerCase()));
    }

    public VCardPropertyScribe(Class<T> clazz, String propertyName, QName qname) {
        this.clazz = clazz;
        this.propertyName = propertyName;
        this.qname = qname;
    }

    public Class<T> getPropertyClass() {
        return this.clazz;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public QName getQName() {
        return this.qname;
    }

    public final VCardParameters prepareParameters(T property, VCardVersion version, VCard vcard) {
        VCardParameters copy = new VCardParameters(((VCardProperty)property).getParameters());
        this._prepareParameters(property, copy, version, vcard);
        return copy;
    }

    public final VCardDataType defaultDataType(VCardVersion version) {
        return this._defaultDataType(version);
    }

    public final VCardDataType dataType(T property, VCardVersion version) {
        return this._dataType(property, version);
    }

    public final String writeText(T property, WriteContext context) {
        return this._writeText(property, context);
    }

    public final void writeXml(T property, Element element) {
        XCardElement xCardElement = new XCardElement(element);
        this._writeXml(property, xCardElement);
    }

    public final JCardValue writeJson(T property) {
        return this._writeJson(property);
    }

    public final T parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        T property = this._parseText(value, dataType, parameters, context);
        ((VCardProperty)property).setParameters(parameters);
        return property;
    }

    public final T parseXml(Element element, VCardParameters parameters, ParseContext context) {
        T property = this._parseXml(new XCardElement(element), parameters, context);
        ((VCardProperty)property).setParameters(parameters);
        return property;
    }

    public final T parseHtml(HCardElement element, ParseContext context) {
        return this._parseHtml(element, context);
    }

    public final T parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        T property = this._parseJson(value, dataType, parameters, context);
        ((VCardProperty)property).setParameters(parameters);
        return property;
    }

    protected void _prepareParameters(T property, VCardParameters copy, VCardVersion version, VCard vcard) {
    }

    protected abstract VCardDataType _defaultDataType(VCardVersion var1);

    protected VCardDataType _dataType(T property, VCardVersion version) {
        return this._defaultDataType(version);
    }

    protected abstract String _writeText(T var1, WriteContext var2);

    protected void _writeXml(T property, XCardElement element) {
        String value = this.writeText(property, new WriteContext(VCardVersion.V4_0, null, false));
        VCardDataType dataType = this.dataType(property, VCardVersion.V4_0);
        element.append(dataType, value);
    }

    protected JCardValue _writeJson(T property) {
        String value = this.writeText(property, new WriteContext(VCardVersion.V4_0, null, false));
        return JCardValue.single(value);
    }

    protected abstract T _parseText(String var1, VCardDataType var2, VCardParameters var3, ParseContext var4);

    protected T _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        XCardElement.XCardValue firstValue = element.firstValue();
        VCardDataType dataType = firstValue.getDataType();
        String value = VObjectPropertyValues.escape((String)firstValue.getValue());
        return this._parseText(value, dataType, parameters, context);
    }

    protected T _parseHtml(HCardElement element, ParseContext context) {
        String value = VObjectPropertyValues.escape((String)element.value());
        VCardParameters parameters = new VCardParameters();
        T property = this._parseText(value, null, parameters, context);
        ((VCardProperty)property).setParameters(parameters);
        return property;
    }

    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        String valueStr = VCardPropertyScribe.jcardValueToString(value);
        return this._parseText(valueStr, dataType, parameters, context);
    }

    private static String jcardValueToString(JCardValue value) {
        List<List<String>> structured;
        List<String> multi;
        List<JsonValue> values = value.getValues();
        if (values.size() > 1 && !(multi = value.asMulti()).isEmpty()) {
            return VObjectPropertyValues.writeList(multi);
        }
        if (!values.isEmpty() && values.get(0).getArray() != null && !(structured = value.asStructured()).isEmpty()) {
            return VObjectPropertyValues.writeStructured(structured, (boolean)true);
        }
        return VObjectPropertyValues.escape((String)value.asSingle());
    }

    protected static Temporal date(String value) {
        return VCardDateFormat.parse(value);
    }

    protected static DateWriter date(Temporal date) {
        return new DateWriter(date);
    }

    protected static CannotParseException missingXmlElements(VCardDataType ... dataTypes) {
        String[] elements = new String[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            VCardDataType dataType = dataTypes[i];
            elements[i] = dataType == null ? "unknown" : dataType.getName().toLowerCase();
        }
        return VCardPropertyScribe.missingXmlElements(elements);
    }

    protected static CannotParseException missingXmlElements(String ... elements) {
        return new CannotParseException(0, Arrays.toString(elements));
    }

    protected static void handlePrefParam(VCardProperty property, VCardParameters parameters, VCardVersion version, VCard vcard) {
        block1 : switch (version) {
            case V2_1: 
            case V3_0: {
                parameters.setPref(null);
                VCardProperty mostPreferred = null;
                Integer lowestPref = null;
                for (VCardProperty p : vcard.getProperties(property.getClass())) {
                    Integer pref;
                    try {
                        pref = p.getParameters().getPref();
                    }
                    catch (IllegalStateException e) {
                        continue;
                    }
                    if (pref == null || lowestPref != null && pref >= lowestPref) continue;
                    mostPreferred = p;
                    lowestPref = pref;
                }
                if (property != mostPreferred) break;
                parameters.put("TYPE", "pref");
                break;
            }
            case V4_0: {
                for (String type : property.getParameters().get("TYPE")) {
                    if (!"pref".equalsIgnoreCase(type)) continue;
                    parameters.remove("TYPE", type);
                    parameters.setPref(1);
                    break block1;
                }
                break;
            }
        }
    }

    protected static String escape(String value, WriteContext context) {
        if (context.getVersion() == VCardVersion.V2_1) {
            return value;
        }
        return VObjectPropertyValues.escape((String)value);
    }

    protected static class DateWriter {
        private Temporal date;
        private boolean extended = false;

        public DateWriter(Temporal date) {
            this.date = date;
        }

        public DateWriter extended(boolean extended) {
            this.extended = extended;
            return this;
        }

        public String write() {
            VCardDateFormat format = this.extended ? VCardDateFormat.EXTENDED : VCardDateFormat.BASIC;
            return format.format(this.date);
        }
    }
}

