/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.DateOrTimeProperty;
import ezvcard.util.PartialDate;
import ezvcard.util.VCardDateFormat;
import java.time.temporal.Temporal;

public abstract class DateOrTimePropertyScribe<T extends DateOrTimeProperty>
extends VCardPropertyScribe<T> {
    public DateOrTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                return VCardDataType.DATE_AND_OR_TIME;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(T property, VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return null;
            }
            case V4_0: {
                if (((DateOrTimeProperty)property).getText() != null) {
                    return VCardDataType.TEXT;
                }
                if (((DateOrTimeProperty)property).getDate() != null) {
                    return VCardDateFormat.hasTime(((DateOrTimeProperty)property).getDate()) ? VCardDataType.DATE_TIME : VCardDataType.DATE;
                }
                if (((DateOrTimeProperty)property).getPartialDate() != null) {
                    return ((DateOrTimeProperty)property).getPartialDate().hasTimeComponent() ? VCardDataType.DATE_TIME : VCardDataType.DATE;
                }
                return VCardDataType.DATE_AND_OR_TIME;
            }
        }
        return null;
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        VCardVersion version = context.getVersion();
        Temporal date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            boolean extended = version == VCardVersion.V3_0;
            return DateOrTimePropertyScribe.date(date).extended(extended).write();
        }
        if (version == VCardVersion.V4_0) {
            String text = ((DateOrTimeProperty)property).getText();
            if (text != null) {
                return VObjectPropertyValues.escape((String)text);
            }
            PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
            if (partialDate != null) {
                return partialDate.toISO8601(false);
            }
        }
        return "";
    }

    @Override
    protected T _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        if (context.getVersion() == VCardVersion.V4_0 && dataType == VCardDataType.TEXT) {
            return this.newInstance(value);
        }
        return this.parse(value, context);
    }

    @Override
    protected void _writeXml(T property, XCardElement parent) {
        Temporal date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            String value = DateOrTimePropertyScribe.date(date).extended(false).write();
            VCardDataType dataType = VCardDateFormat.hasTime(date) ? VCardDataType.DATE_TIME : VCardDataType.DATE;
            parent.append(dataType, value);
            return;
        }
        PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
        if (partialDate != null) {
            VCardDataType dataType = partialDate.hasTimeComponent() && partialDate.hasDateComponent() ? VCardDataType.DATE_TIME : (partialDate.hasTimeComponent() ? VCardDataType.TIME : (partialDate.hasDateComponent() ? VCardDataType.DATE : VCardDataType.DATE_AND_OR_TIME));
            parent.append(dataType, partialDate.toISO8601(false));
            return;
        }
        String text = ((DateOrTimeProperty)property).getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        parent.append(VCardDataType.DATE_AND_OR_TIME, "");
    }

    @Override
    protected T _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String value = element.first(VCardDataType.DATE, VCardDataType.DATE_TIME, VCardDataType.DATE_AND_OR_TIME);
        if (value != null) {
            return this.parse(value, context);
        }
        value = element.first(VCardDataType.TEXT);
        if (value != null) {
            return this.newInstance(value);
        }
        throw DateOrTimePropertyScribe.missingXmlElements(VCardDataType.DATE, VCardDataType.DATE_TIME, VCardDataType.DATE_AND_OR_TIME, VCardDataType.TEXT);
    }

    @Override
    protected T _parseHtml(HCardElement element, ParseContext context) {
        String datetime;
        String value = null;
        if ("time".equals(element.tagName()) && (datetime = element.attr("datetime")).length() > 0) {
            value = datetime;
        }
        if (value == null) {
            value = element.value();
        }
        return this.parse(value, context);
    }

    @Override
    protected JCardValue _writeJson(T property) {
        Temporal date = ((DateOrTimeProperty)property).getDate();
        if (date != null) {
            String value = DateOrTimePropertyScribe.date(date).extended(true).write();
            return JCardValue.single(value);
        }
        PartialDate partialDate = ((DateOrTimeProperty)property).getPartialDate();
        if (partialDate != null) {
            String value = partialDate.toISO8601(true);
            return JCardValue.single(value);
        }
        String text = ((DateOrTimeProperty)property).getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        return JCardValue.single("");
    }

    @Override
    protected T _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        if (dataType == VCardDataType.TEXT) {
            return this.newInstance(valueStr);
        }
        return this.parse(valueStr, context);
    }

    private T parse(String value, ParseContext context) {
        try {
            return this.newInstance(DateOrTimePropertyScribe.date(value));
        }
        catch (IllegalArgumentException e) {
            if (context.getVersion() == VCardVersion.V2_1 || context.getVersion() == VCardVersion.V3_0) {
                throw new CannotParseException(5, new Object[0]);
            }
            try {
                return this.newInstance(PartialDate.parse(value));
            }
            catch (IllegalArgumentException e2) {
                context.addWarning(6, new Object[0]);
                return this.newInstance(value);
            }
        }
    }

    protected abstract T newInstance(String var1);

    protected abstract T newInstance(Temporal var1);

    protected abstract T newInstance(PartialDate var1);
}

