/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io;

import ezvcard.Messages;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.Address;
import ezvcard.property.Label;
import ezvcard.property.ProductId;
import ezvcard.property.RawProperty;
import ezvcard.property.VCardProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class StreamWriter
implements Closeable {
    protected ScribeIndex index = new ScribeIndex();
    protected boolean addProdId = true;
    protected boolean versionStrict = true;

    public void write(VCard vcard) throws IOException {
        List<VCardProperty> properties = this.prepare(vcard);
        this._write(vcard, properties);
    }

    protected abstract void _write(VCard var1, List<VCardProperty> var2) throws IOException;

    protected abstract VCardVersion getTargetVersion();

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    private List<VCardProperty> prepare(VCard vcard) {
        VCardVersion targetVersion = this.getTargetVersion();
        ArrayList<VCardProperty> propertiesToAdd = new ArrayList<VCardProperty>();
        HashSet unregistered = new HashSet();
        VCardProperty prodIdProperty = null;
        for (VCardProperty property : vcard) {
            Address address;
            String labelStr;
            if (this.versionStrict && !property.isSupportedBy(targetVersion)) continue;
            if (property instanceof ProductId) {
                prodIdProperty = property;
                continue;
            }
            if (!this.index.hasPropertyScribe(property)) {
                unregistered.add(property.getClass());
                continue;
            }
            propertiesToAdd.add(property);
            if (targetVersion != VCardVersion.V2_1 && targetVersion != VCardVersion.V3_0 || !(property instanceof Address) || (labelStr = (address = (Address)property).getLabel()) == null) continue;
            Label label = new Label(labelStr);
            label.getTypes().addAll(address.getTypes());
            propertiesToAdd.add(label);
        }
        if (!unregistered.isEmpty()) {
            ArrayList<String> classes = new ArrayList<String>(unregistered.size());
            for (Class clazz : unregistered) {
                classes.add(clazz.getName());
            }
            throw Messages.INSTANCE.getIllegalArgumentException(14, classes);
        }
        if (this.addProdId) {
            prodIdProperty = targetVersion == VCardVersion.V2_1 ? new RawProperty("X-PRODID", "ez-vcard 0.12.1") : new ProductId("ez-vcard 0.12.1");
        }
        if (prodIdProperty != null) {
            propertiesToAdd.add(0, prodIdProperty);
        }
        return propertiesToAdd;
    }
}

