/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ActiveDirectoryObject;
import com.azure.resourcemanager.containerregistry.models.TokenCertificate;
import com.azure.resourcemanager.containerregistry.models.TokenPassword;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class TokenCredentialsProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TokenCredentialsProperties.class);
    @JsonProperty(value="activeDirectoryObject")
    private ActiveDirectoryObject activeDirectoryObject;
    @JsonProperty(value="certificates")
    private List<TokenCertificate> certificates;
    @JsonProperty(value="passwords")
    private List<TokenPassword> passwords;

    public ActiveDirectoryObject activeDirectoryObject() {
        return this.activeDirectoryObject;
    }

    public TokenCredentialsProperties withActiveDirectoryObject(ActiveDirectoryObject activeDirectoryObject) {
        this.activeDirectoryObject = activeDirectoryObject;
        return this;
    }

    public List<TokenCertificate> certificates() {
        return this.certificates;
    }

    public TokenCredentialsProperties withCertificates(List<TokenCertificate> certificates) {
        this.certificates = certificates;
        return this;
    }

    public List<TokenPassword> passwords() {
        return this.passwords;
    }

    public TokenCredentialsProperties withPasswords(List<TokenPassword> passwords) {
        this.passwords = passwords;
        return this;
    }

    public void validate() {
        if (this.activeDirectoryObject() != null) {
            this.activeDirectoryObject().validate();
        }
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.passwords() != null) {
            this.passwords().forEach(e -> e.validate());
        }
    }
}

