/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.BaseImageDependency;
import com.azure.resourcemanager.containerregistry.models.DockerTaskStep;
import com.azure.resourcemanager.containerregistry.models.EncodedTaskStep;
import com.azure.resourcemanager.containerregistry.models.FileTaskStep;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=TaskStepProperties.class)
@JsonTypeName(value="TaskStepProperties")
@JsonSubTypes(value={@JsonSubTypes.Type(name="FileTask", value=FileTaskStep.class), @JsonSubTypes.Type(name="EncodedTask", value=EncodedTaskStep.class), @JsonSubTypes.Type(name="Docker", value=DockerTaskStep.class)})
public class TaskStepProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TaskStepProperties.class);
    @JsonProperty(value="baseImageDependencies", access=JsonProperty.Access.WRITE_ONLY)
    private List<BaseImageDependency> baseImageDependencies;
    @JsonProperty(value="contextPath")
    private String contextPath;
    @JsonProperty(value="contextAccessToken")
    private String contextAccessToken;

    public List<BaseImageDependency> baseImageDependencies() {
        return this.baseImageDependencies;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public TaskStepProperties withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String contextAccessToken() {
        return this.contextAccessToken;
    }

    public TaskStepProperties withContextAccessToken(String contextAccessToken) {
        this.contextAccessToken = contextAccessToken;
        return this;
    }

    public void validate() {
        if (this.baseImageDependencies() != null) {
            this.baseImageDependencies().forEach(e -> e.validate());
        }
    }
}

