/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.Actor;
import com.azure.resourcemanager.containerregistry.models.Request;
import com.azure.resourcemanager.containerregistry.models.Source;
import com.azure.resourcemanager.containerregistry.models.Target;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class EventContent {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EventContent.class);
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="timestamp")
    private OffsetDateTime timestamp;
    @JsonProperty(value="action")
    private String action;
    @JsonProperty(value="target")
    private Target target;
    @JsonProperty(value="request")
    private Request request;
    @JsonProperty(value="actor")
    private Actor actor;
    @JsonProperty(value="source")
    private Source source;

    public String id() {
        return this.id;
    }

    public EventContent withId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public EventContent withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String action() {
        return this.action;
    }

    public EventContent withAction(String action) {
        this.action = action;
        return this;
    }

    public Target target() {
        return this.target;
    }

    public EventContent withTarget(Target target) {
        this.target = target;
        return this;
    }

    public Request request() {
        return this.request;
    }

    public EventContent withRequest(Request request) {
        this.request = request;
        return this;
    }

    public Actor actor() {
        return this.actor;
    }

    public EventContent withActor(Actor actor) {
        this.actor = actor;
        return this;
    }

    public Source source() {
        return this.source;
    }

    public EventContent withSource(Source source) {
        this.source = source;
        return this;
    }

    public void validate() {
        if (this.target() != null) {
            this.target().validate();
        }
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.actor() != null) {
            this.actor().validate();
        }
        if (this.source() != null) {
            this.source().validate();
        }
    }
}

