/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RegistryProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RegistryProperties.class);
    @JsonProperty(value="loginServer", access=JsonProperty.Access.WRITE_ONLY)
    private String loginServer;
    @JsonProperty(value="creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private Status status;
    @JsonProperty(value="adminUserEnabled")
    private Boolean adminUserEnabled;
    @JsonProperty(value="networkRuleSet")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="policies")
    private Policies policies;
    @JsonProperty(value="encryption")
    private EncryptionProperty encryption;
    @JsonProperty(value="dataEndpointEnabled")
    private Boolean dataEndpointEnabled;
    @JsonProperty(value="dataEndpointHostNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> dataEndpointHostNames;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="networkRuleBypassOptions")
    private NetworkRuleBypassOptions networkRuleBypassOptions;

    public String loginServer() {
        return this.loginServer;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Status status() {
        return this.status;
    }

    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    public RegistryProperties withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public RegistryProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public Policies policies() {
        return this.policies;
    }

    public RegistryProperties withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public EncryptionProperty encryption() {
        return this.encryption;
    }

    public RegistryProperties withEncryption(EncryptionProperty encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.dataEndpointEnabled;
    }

    public RegistryProperties withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        this.dataEndpointEnabled = dataEndpointEnabled;
        return this;
    }

    public List<String> dataEndpointHostNames() {
        return this.dataEndpointHostNames;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public RegistryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.networkRuleBypassOptions;
    }

    public RegistryProperties withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        this.networkRuleBypassOptions = networkRuleBypassOptions;
        return this;
    }

    public void validate() {
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.policies() != null) {
            this.policies().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

