/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.ExportPipelineProperties;
import com.azure.resourcemanager.containerregistry.models.ExportPipelineTargetProperties;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.PipelineOptions;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ExportPipelineInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExportPipelineInner.class);
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private ExportPipelineProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public String location() {
        return this.location;
    }

    public ExportPipelineInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public IdentityProperties identity() {
        return this.identity;
    }

    public ExportPipelineInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private ExportPipelineProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ExportPipelineTargetProperties target() {
        return this.innerProperties() == null ? null : this.innerProperties().target();
    }

    public ExportPipelineInner withTarget(ExportPipelineTargetProperties target) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportPipelineProperties();
        }
        this.innerProperties().withTarget(target);
        return this;
    }

    public List<PipelineOptions> options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public ExportPipelineInner withOptions(List<PipelineOptions> options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportPipelineProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

