/*
 * Decompiled with CFR 0.152.
 */
package jdk.swing.interop;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowFocusListener;
import jdk.swing.interop.LightweightContentWrapper;
import sun.awt.AWTAccessor;
import sun.awt.UngrabEvent;
import sun.swing.JLightweightFrame;

public class LightweightFrameWrapper {
    JLightweightFrame lwFrame = new JLightweightFrame();

    private JLightweightFrame getLightweightFrame() {
        return this.lwFrame;
    }

    public void notifyDisplayChanged(int scaleFactor) {
        if (this.lwFrame != null) {
            this.lwFrame.notifyDisplayChanged(scaleFactor, scaleFactor);
        }
    }

    public void notifyDisplayChanged(double scaleFactorX, double scaleFactorY) {
        if (this.lwFrame != null) {
            this.lwFrame.notifyDisplayChanged(scaleFactorX, scaleFactorY);
        }
    }

    void overrideNativeWindowHandle(long handle, Runnable closeWindow) {
        if (this.lwFrame != null) {
            this.lwFrame.overrideNativeWindowHandle(handle, closeWindow);
        }
    }

    public void setHostBounds(int x, int y, int w, int h) {
        if (this.lwFrame != null) {
            this.lwFrame.setHostBounds(x, y, w, h);
        }
    }

    public void dispose() {
        if (this.lwFrame != null) {
            this.lwFrame.dispose();
        }
    }

    public void addWindowFocusListener(WindowFocusListener listener) {
        if (this.lwFrame != null) {
            this.lwFrame.addWindowFocusListener(listener);
        }
    }

    public void setVisible(boolean visible) {
        if (this.lwFrame != null) {
            this.lwFrame.setVisible(visible);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.lwFrame != null) {
            this.lwFrame.setBounds(x, y, w, h);
        }
    }

    public void setContent(LightweightContentWrapper lwCntWrapper) {
        if (this.lwFrame != null) {
            this.lwFrame.setContent(lwCntWrapper.getContent());
        }
    }

    public void emulateActivation(boolean activate) {
        if (this.lwFrame != null) {
            this.lwFrame.emulateActivation(activate);
        }
    }

    public MouseEvent createMouseEvent(LightweightFrameWrapper lwFrame, int swingID, long swingWhen, int swingModifiers, int relX, int relY, int absX, int absY, int clickCount, boolean swingPopupTrigger, int swingButton) {
        return new MouseEvent(lwFrame.getLightweightFrame(), swingID, swingWhen, swingModifiers, relX, relY, absX, absY, clickCount, swingPopupTrigger, swingButton);
    }

    public MouseWheelEvent createMouseWheelEvent(LightweightFrameWrapper lwFrame, int swingModifiers, int x, int y, int wheelRotation) {
        return new MouseWheelEvent(lwFrame.getLightweightFrame(), 507, System.currentTimeMillis(), swingModifiers, x, y, 0, 0, 0, false, 0, 1, wheelRotation);
    }

    public KeyEvent createKeyEvent(LightweightFrameWrapper lwFrame, int swingID, long swingWhen, int swingModifiers, int swingKeyCode, char swingChar) {
        return new KeyEvent(lwFrame.getLightweightFrame(), swingID, swingWhen, swingModifiers, swingKeyCode, swingChar);
    }

    public AWTEvent createUngrabEvent(LightweightFrameWrapper lwFrame) {
        return new UngrabEvent(lwFrame.getLightweightFrame());
    }

    public Component findComponentAt(LightweightFrameWrapper cont, int x, int y, boolean ignoreEnabled) {
        JLightweightFrame lwframe = cont.getLightweightFrame();
        return AWTAccessor.getContainerAccessor().findComponentAt(lwframe, x, y, ignoreEnabled);
    }

    public boolean isCompEqual(Component c, LightweightFrameWrapper lwFrame) {
        return c != lwFrame.getLightweightFrame();
    }
}

