/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font.encoding;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.font.encoding.MacRomanEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.StandardEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;

public abstract class Encoding
implements COSObjectable {
    protected final Map<Integer, String> codeToName = new HashMap<Integer, String>(250);
    protected final Map<String, Integer> inverted = new HashMap<String, Integer>(250);
    private Set<String> names;

    public static Encoding getInstance(COSName name) {
        if (COSName.STANDARD_ENCODING.equals(name)) {
            return StandardEncoding.INSTANCE;
        }
        if (COSName.WIN_ANSI_ENCODING.equals(name)) {
            return WinAnsiEncoding.INSTANCE;
        }
        if (COSName.MAC_ROMAN_ENCODING.equals(name)) {
            return MacRomanEncoding.INSTANCE;
        }
        return null;
    }

    public Map<Integer, String> getCodeToNameMap() {
        return Collections.unmodifiableMap(this.codeToName);
    }

    public Map<String, Integer> getNameToCodeMap() {
        return Collections.unmodifiableMap(this.inverted);
    }

    protected void add(int code, String name) {
        this.codeToName.put(code, name);
        this.inverted.put(name, code);
    }

    public boolean contains(String name) {
        if (this.names == null) {
            this.names = new HashSet<String>(this.codeToName.size());
            this.names.addAll(this.codeToName.values());
        }
        return this.names.contains(name);
    }

    public boolean contains(int code) {
        return this.codeToName.containsKey(code);
    }

    public String getName(int code) {
        String name = this.codeToName.get(code);
        if (name != null) {
            return name;
        }
        return ".notdef";
    }

    public abstract String getEncodingName();
}

