/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.util.Matrix;

public class PDCIDFontType2
extends PDCIDFont {
    private static final Log LOG = LogFactory.getLog(PDCIDFontType2.class);
    private final TrueTypeFont ttf;
    private final int[] cid2gid;
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private final CmapSubtable cmap;
    private Matrix fontMatrix;
    private BoundingBox fontBBox;

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent) throws IOException {
        this(fontDictionary, parent, null);
    }

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent, TrueTypeFont trueTypeFont) throws IOException {
        super(fontDictionary, parent);
        PDFontDescriptor fd = this.getFontDescriptor();
        if (trueTypeFont != null) {
            this.ttf = trueTypeFont;
            this.isEmbedded = true;
            this.isDamaged = false;
        } else {
            boolean fontIsDamaged = false;
            TrueTypeFont ttfFont = null;
            PDStream ff2Stream = fd.getFontFile2();
            PDStream ff3Stream = fd.getFontFile3();
            if (ff2Stream == null && ff3Stream == null) {
                ff2Stream = fd.getFontFile();
            }
            if (ff2Stream != null) {
                try {
                    TTFParser ttfParser = new TTFParser(true);
                    ttfFont = ttfParser.parse(ff2Stream.createInputStream());
                }
                catch (NullPointerException e) {
                    LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                    fontIsDamaged = true;
                }
                catch (IOException e) {
                    LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                    fontIsDamaged = true;
                }
            } else if (ff3Stream != null) {
                try {
                    OTFParser otfParser = new OTFParser(true);
                    OpenTypeFont otf = otfParser.parse(ff3Stream.createInputStream());
                    ttfFont = otf;
                    if (otf.isPostScript()) {
                        throw new IOException("Not implemented: OpenType font with CFF table " + this.getBaseFont());
                    }
                    if (otf.hasLayoutTables()) {
                        LOG.error((Object)("OpenType Layout tables used in font " + this.getBaseFont() + " are not implemented in PDFBox and will be ignored"));
                    }
                }
                catch (NullPointerException e) {
                    fontIsDamaged = true;
                    LOG.warn((Object)("Could not read embedded OTF for font " + this.getBaseFont()), (Throwable)e);
                }
                catch (IOException e) {
                    fontIsDamaged = true;
                    LOG.warn((Object)("Could not read embedded OTF for font " + this.getBaseFont()), (Throwable)e);
                }
            }
            this.isEmbedded = ttfFont != null;
            this.isDamaged = fontIsDamaged;
            if (ttfFont == null) {
                CIDFontMapping mapping = FontMappers.instance().getCIDFont(this.getBaseFont(), this.getFontDescriptor(), this.getCIDSystemInfo());
                ttfFont = mapping.isCIDFont() ? (TrueTypeFont)mapping.getFont() : (TrueTypeFont)mapping.getTrueTypeFont();
                if (mapping.isFallback()) {
                    LOG.warn((Object)("Using fallback font " + ttfFont.getName() + " for CID-keyed TrueType font " + this.getBaseFont()));
                }
            }
            this.ttf = ttfFont;
        }
        this.cmap = this.ttf.getUnicodeCmap(false);
        this.cid2gid = this.readCIDToGIDMap();
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            this.fontMatrix = new Matrix(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        }
        return this.fontMatrix;
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = this.generateBoundingBox();
        }
        return this.fontBBox;
    }

    private BoundingBox generateBoundingBox() throws IOException {
        PDRectangle bbox;
        if (this.getFontDescriptor() != null && ((bbox = this.getFontDescriptor().getFontBoundingBox()).getLowerLeftX() != 0.0f || bbox.getLowerLeftY() != 0.0f || bbox.getUpperRightX() != 0.0f || bbox.getUpperRightY() != 0.0f)) {
            return new BoundingBox(bbox.getLowerLeftX(), bbox.getLowerLeftY(), bbox.getUpperRightX(), bbox.getUpperRightY());
        }
        return this.ttf.getFontBBox();
    }

    private int[] readCIDToGIDMap() throws IOException {
        int[] cid2gid = null;
        COSBase map = this.dict.getDictionaryObject(COSName.CID_TO_GID_MAP);
        if (map instanceof COSStream) {
            COSStream stream = (COSStream)map;
            COSInputStream is = stream.createInputStream();
            byte[] mapAsBytes = IOUtils.toByteArray(is);
            IOUtils.closeQuietly(is);
            int numberOfInts = mapAsBytes.length / 2;
            cid2gid = new int[numberOfInts];
            int offset = 0;
            for (int index = 0; index < numberOfInts; ++index) {
                int gid;
                cid2gid[index] = gid = (mapAsBytes[offset] & 0xFF) << 8 | mapAsBytes[offset + 1] & 0xFF;
                offset += 2;
            }
        }
        return cid2gid;
    }

    private Map<Integer, Integer> invert(int[] cid2gid) {
        if (cid2gid == null) {
            return null;
        }
        HashMap<Integer, Integer> inverse = new HashMap<Integer, Integer>(cid2gid.length);
        for (int i = 0; i < cid2gid.length; ++i) {
            inverse.put(cid2gid[i], i);
        }
        return inverse;
    }

    @Override
    public int codeToCID(int code) {
        CMap cMap = this.parent.getCMap();
        if (!cMap.hasCIDMappings() && cMap.hasUnicodeMappings()) {
            return cMap.toUnicode(code).codePointAt(0);
        }
        return cMap.toCID(code);
    }

    @Override
    public int codeToGID(int code) throws IOException {
        if (!this.isEmbedded) {
            if (this.cid2gid != null && !this.isDamaged) {
                LOG.warn((Object)("Using non-embedded GIDs in font " + this.getName()));
                int cid = this.codeToCID(code);
                return this.cid2gid[cid];
            }
            String unicode = this.parent.toUnicode(code);
            if (unicode == null) {
                LOG.warn((Object)("Failed to find a character mapping for " + code + " in " + this.getName()));
                return this.codeToCID(code);
            }
            if (unicode.length() > 1) {
                LOG.warn((Object)"Trying to map multi-byte character using 'cmap', result will be poor");
            }
            return this.cmap.getGlyphId(unicode.codePointAt(0));
        }
        int cid = this.codeToCID(code);
        if (this.cid2gid != null) {
            if (cid < this.cid2gid.length) {
                return this.cid2gid[cid];
            }
            return 0;
        }
        if (cid < this.ttf.getNumberOfGlyphs()) {
            return cid;
        }
        return 0;
    }

    @Override
    public float getHeight(int code) throws IOException {
        return (this.ttf.getHorizontalHeader().getAscender() + -this.ttf.getHorizontalHeader().getDescender()) / this.ttf.getUnitsPerEm();
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int gid = this.codeToGID(code);
        int width = this.ttf.getAdvanceWidth(gid);
        int unitsPerEM = this.ttf.getUnitsPerEm();
        if (unitsPerEM != 1000) {
            width = (int)((float)width * (1000.0f / (float)unitsPerEM));
        }
        return width;
    }

    @Override
    public byte[] encode(int unicode) {
        int cid = -1;
        if (this.isEmbedded) {
            if (this.parent.getCMap().getName().startsWith("Identity-")) {
                if (this.cmap != null) {
                    cid = this.cmap.getGlyphId(unicode);
                }
            } else if (this.parent.getCMapUCS2() != null) {
                cid = this.parent.getCMapUCS2().toCID(unicode);
            }
            if (cid == -1) {
                cid = 0;
            }
        } else {
            cid = this.cmap.getGlyphId(unicode);
        }
        if (cid == 0) {
            throw new IllegalArgumentException(String.format("No glyph for U+%04X in font %s", unicode, this.getName()));
        }
        return new byte[]{(byte)(cid >> 8 & 0xFF), (byte)(cid & 0xFF)};
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }

    @Override
    public GeneralPath getPath(int code) throws IOException {
        if (this.ttf instanceof OpenTypeFont && ((OpenTypeFont)this.ttf).isPostScript()) {
            int cid = this.codeToCID(code);
            Type2CharString charstring = ((OpenTypeFont)this.ttf).getCFF().getFont().getType2CharString(cid);
            return charstring.getPath();
        }
        int gid = this.codeToGID(code);
        GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
        if (glyph != null) {
            return glyph.getPath();
        }
        return new GeneralPath();
    }

    @Override
    public boolean hasGlyph(int code) throws IOException {
        return this.codeToGID(code) != 0;
    }
}

