/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

final class OperatorMarker {
    public static final String BEGIN_TEXT_OBJECT = "BT";
    public static final String END_TEXT_OBJECT = "ET";
    public static final String SAVE_GRAPHICS_STATE = "q";
    public static final String RESTORE_GRAPHICS_STATE = "Q";
    public static final String CONCAT = "cm";
    public static final String INLINE_IMAGE_BEGIN = "BI";
    public static final String IMAGE_DATA = "ID";
    public static final String INLINE_IMAGE_END = "EI";
    private static final Map<String, Style> operatorStyleMap;

    private OperatorMarker() {
    }

    public static Style getStyle(String operator) {
        if (operatorStyleMap.containsKey(operator)) {
            return operatorStyleMap.get(operator);
        }
        return null;
    }

    static {
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        Style common = styleContext.addStyle("common", null);
        StyleConstants.setBold(common, true);
        Style textObjectStyle = styleContext.addStyle("text_object", common);
        StyleConstants.setForeground(textObjectStyle, new Color(0, 100, 0));
        Style graphicsStyle = styleContext.addStyle("graphics", common);
        StyleConstants.setForeground(graphicsStyle, new Color(255, 68, 68));
        Style concatStyle = styleContext.addStyle(CONCAT, common);
        StyleConstants.setForeground(concatStyle, new Color(1, 169, 219));
        Style inlineImage = styleContext.addStyle("inline_image", common);
        StyleConstants.setForeground(inlineImage, new Color(71, 117, 163));
        Style imageData = styleContext.addStyle(IMAGE_DATA, common);
        StyleConstants.setForeground(imageData, new Color(255, 165, 0));
        HashMap<String, Style> styleMap = new HashMap<String, Style>();
        styleMap.put(BEGIN_TEXT_OBJECT, textObjectStyle);
        styleMap.put(END_TEXT_OBJECT, textObjectStyle);
        styleMap.put(SAVE_GRAPHICS_STATE, graphicsStyle);
        styleMap.put(RESTORE_GRAPHICS_STATE, graphicsStyle);
        styleMap.put(CONCAT, concatStyle);
        styleMap.put(INLINE_IMAGE_BEGIN, inlineImage);
        styleMap.put(IMAGE_DATA, imageData);
        styleMap.put(INLINE_IMAGE_END, inlineImage);
        operatorStyleMap = styleMap;
    }
}

