/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.DisasterRecoveryConfigsClient;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleInner;
import com.azure.resourcemanager.eventhubs.implementation.DisasterRecoveryPairingAuthorizationRuleImpl;
import com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationRules;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public final class DisasterRecoveryPairingAuthorizationRulesImpl
extends ReadableWrappersImpl<DisasterRecoveryPairingAuthorizationRule, DisasterRecoveryPairingAuthorizationRuleImpl, AuthorizationRuleInner>
implements DisasterRecoveryPairingAuthorizationRules {
    private final EventHubsManager manager;

    public DisasterRecoveryPairingAuthorizationRulesImpl(EventHubsManager manager) {
        this.manager = manager;
    }

    @Override
    public PagedIterable<DisasterRecoveryPairingAuthorizationRule> listByDisasterRecoveryPairing(String resourceGroupName, String namespaceName, String pairingName) {
        return PagedConverter.mapPage(this.inner().listAuthorizationRules(resourceGroupName, namespaceName, pairingName), this::wrapModel);
    }

    @Override
    public PagedFlux<DisasterRecoveryPairingAuthorizationRule> listByDisasterRecoveryPairingAsync(String resourceGroupName, String namespaceName, String pairingName) {
        return PagedConverter.mapPage(this.inner().listAuthorizationRulesAsync(resourceGroupName, namespaceName, pairingName), this::wrapModel);
    }

    @Override
    public Mono<DisasterRecoveryPairingAuthorizationRule> getByNameAsync(String resourceGroupName, String namespaceName, String pairingName, String name) {
        return ((EventHubManagementClient)this.manager.serviceClient()).getDisasterRecoveryConfigs().getAuthorizationRuleAsync(resourceGroupName, namespaceName, pairingName, name).map(this::wrapModel);
    }

    @Override
    public DisasterRecoveryPairingAuthorizationRule getByName(String resourceGroupName, String namespaceName, String pairingName, String name) {
        return (DisasterRecoveryPairingAuthorizationRule)this.getByNameAsync(resourceGroupName, namespaceName, pairingName, name).block();
    }

    public DisasterRecoveryPairingAuthorizationRule getById(String id) {
        return (DisasterRecoveryPairingAuthorizationRule)this.getByIdAsync(id).block();
    }

    public Mono<DisasterRecoveryPairingAuthorizationRule> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.parent().parent().name(), resourceId.name());
    }

    public EventHubsManager manager() {
        return this.manager;
    }

    public DisasterRecoveryConfigsClient inner() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getDisasterRecoveryConfigs();
    }

    protected DisasterRecoveryPairingAuthorizationRuleImpl wrapModel(AuthorizationRuleInner inner) {
        return new DisasterRecoveryPairingAuthorizationRuleImpl(inner, this.manager);
    }
}

