/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.util;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.util.Utils;
import org.apache.struts.util.MessageResources;

public class StrutsContext {
    private final FacesContext fcontext;
    private final ExternalContext econtext;

    public StrutsContext() {
        this(FacesContext.getCurrentInstance());
    }

    public StrutsContext(FacesContext facesContext) {
        this.fcontext = facesContext;
        this.econtext = facesContext.getExternalContext();
    }

    public ActionEvent getActionEvent() {
        return Utils.getMapValue(ActionEvent.class, this.econtext.getRequestMap(), "org.apache.struts.faces.ACTION_EVENT");
    }

    public ActionMapping getActionMapping() {
        return Utils.getMapValue(ActionMapping.class, this.econtext.getRequestMap(), "org.apache.struts.action.mapping.instance");
    }

    public ActionMessages getActionMessages() {
        return Utils.getMapValue(ActionMessages.class, this.econtext.getRequestMap(), "org.apache.struts.action.ACTION_MESSAGE");
    }

    public ActionServlet getActionServlet() {
        return Utils.getMapValue(ActionServlet.class, this.econtext.getApplicationMap(), "org.apache.struts.action.ACTION_SERVLET");
    }

    public boolean isCancelled() {
        Object value = this.econtext.getRequestMap().get("org.apache.struts.action.CANCEL");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public Throwable getException() {
        return Utils.getMapValue(Throwable.class, this.econtext.getRequestMap(), "org.apache.struts.action.EXCEPTION");
    }

    public ExternalContext getExternalContext() {
        return this.econtext;
    }

    public FacesContext getFacesContext() {
        return this.fcontext;
    }

    public Locale getLocale() {
        Locale locale = null;
        if (this.econtext.getSession(false) != null) {
            locale = Utils.getMapValue(Locale.class, this.econtext.getSessionMap(), "org.apache.struts.action.LOCALE");
        }
        if (locale == null) {
            locale = this.econtext.getRequestLocale();
        }
        return locale;
    }

    public MessageResources getMessageResources() {
        return Utils.getMapValue(MessageResources.class, this.econtext.getRequestMap(), "org.apache.struts.action.MESSAGE");
    }

    public ModuleConfig getModuleConfig() {
        return StrutsContext.getModuleConfig(this.econtext);
    }

    public static ModuleConfig getModuleConfig(FacesContext facesContext) {
        return StrutsContext.getModuleConfig(facesContext.getExternalContext());
    }

    public static ModuleConfig getModuleConfig(ExternalContext externalContext) {
        ModuleConfig moduleConfig = Utils.getMapValue(ModuleConfig.class, externalContext.getRequestMap(), "org.apache.struts.action.MODULE");
        if (moduleConfig == null) {
            moduleConfig = Utils.getMapValue(ModuleConfig.class, externalContext.getApplicationMap(), "org.apache.struts.action.MODULE");
        }
        if (moduleConfig == null) {
            throw new IllegalArgumentException("Cannot find module configuration");
        }
        return moduleConfig;
    }

    public static String uri(FacesContext context) {
        StringBuilder sb = new StringBuilder();
        ExternalContext externalContext = context.getExternalContext();
        if (StrutsContext.isServletRequest(externalContext)) {
            StrutsContext.servletUri(sb, externalContext);
        } else if (StrutsContext.isPortletRequest(externalContext)) {
            StrutsContext.portletUri(sb, externalContext);
        } else {
            throw new IllegalArgumentException("Request is neither HttpServletRequest nor PortletRequest");
        }
        return sb.append(context.getViewRoot().getViewId()).toString();
    }

    private static void portletUri(StringBuilder sb, ExternalContext context) {
        Object request = context.getRequest();
        try {
            String scheme = (String)MethodUtils.invokeMethod((Object)request, (String)"getScheme", null);
            String serverName = (String)MethodUtils.invokeMethod((Object)request, (String)"getServerName", null);
            int serverPort = (Integer)MethodUtils.invokeMethod((Object)request, (String)"getServerPort", null);
            String contextPath = (String)MethodUtils.invokeMethod((Object)request, (String)"getContextPath", null);
            StrutsContext.buildUri(sb, scheme, serverName, serverPort, contextPath);
        }
        catch (InvocationTargetException e) {
            throw new FacesException(e.getTargetException());
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static boolean isPortletRequest(ExternalContext context) {
        Object request = context.getRequest();
        for (Class<?> clazz = request.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces == null) continue;
            for (Class<?> inter : interfaces) {
                if (!"javax.portlet.PortletRequest".equals(inter.getName()) && !"jakarta.portlet.PortletRequest".equals(inter.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void servletUri(StringBuilder sb, ExternalContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        StrutsContext.buildUri(sb, request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
    }

    private static boolean isServletRequest(ExternalContext context) {
        Object request = context.getRequest();
        return request instanceof HttpServletRequest;
    }

    private static void buildUri(StringBuilder sb, String scheme, String serverName, int serverPort, String contextPath) {
        sb.append(scheme).append("://").append(serverName);
        if (!("http".equals(scheme) && serverPort == 80 || "https".equals(scheme) && serverPort == 443)) {
            sb.append(':').append(serverPort);
        }
        sb.append(contextPath);
    }
}

