/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.struts.util.MessageResources;

public class MessagesMap
implements Map<String, String> {
    private final Locale locale;
    private final MessageResources messages;

    public MessagesMap(MessageResources messages, Locale locale) {
        if (messages == null) {
            throw new NullPointerException();
        }
        this.messages = messages;
        this.locale = locale;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && this.messages.isPresent(this.locale, key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MessagesMap other = (MessagesMap)o;
        if (!this.messages.equals(other.getMessages())) {
            return false;
        }
        return Objects.equals(this.locale, other.locale);
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return "??????";
        }
        return this.messages.getMessage(this.locale, key.toString());
    }

    @Override
    public int hashCode() {
        int value = this.messages.hashCode();
        if (this.locale != null) {
            value ^= this.locale.hashCode();
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException();
    }

    Locale getLocale() {
        return this.locale;
    }

    MessageResources getMessages() {
        return this.messages;
    }
}

