/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.apache.struts.faces.renderer.AbstractRenderer;
import org.apache.struts.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRenderer
extends AbstractRenderer {
    private final Logger log = LoggerFactory.getLogger(WriteRenderer.class);

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getId();
        if (id != null && id.startsWith("j_id")) {
            id = null;
        }
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        this.log.trace("id='{}', style='{}', styleClass='{}'", new Object[]{id, style, styleClass});
        if (id != null || style != null || styleClass != null) {
            writer.startElement("span", component);
            if (id != null) {
                writer.writeAttribute("id", (Object)component.getClientId(context), "id");
            }
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            writer.writeText((Object)"", null);
        }
        String text = this.getText(context, component);
        this.log.atTrace().setMessage("encodeEnd({},{})").addArgument(() -> component.getClientId(context)).addArgument((Object)text).log();
        writer.write(text);
        if (id != null || style != null || styleClass != null) {
            writer.endElement("span");
        }
    }

    protected String getText(FacesContext context, UIComponent component) {
        String text = this.getAsString(context, component, ((ValueHolder)component).getValue());
        Boolean filter = (Boolean)component.getAttributes().get("filter");
        if (filter == null) {
            filter = Boolean.FALSE;
        }
        if (filter.booleanValue()) {
            return ResponseUtils.filter((String)text);
        }
        return text;
    }
}

