/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import org.apache.struts.faces.renderer.WriteRenderer;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ResponseUtils;

public class MessageRenderer
extends WriteRenderer {
    @Override
    protected String getText(FacesContext context, UIComponent component) {
        MessageResources resources;
        String bundle = (String)component.getAttributes().get("bundle");
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)context.getExternalContext().getApplicationMap().get(bundle)) == null) {
            throw new IllegalArgumentException("MessageResources bundle " + bundle + " not found");
        }
        Object value = component.getAttributes().get("key");
        if (value == null) {
            value = ((ValueHolder)component).getValue();
        }
        if (value == null) {
            throw new NullPointerException("Component '" + component.getClientId(context) + "' has no current value");
        }
        String key = value.toString();
        ArrayList<Object> list = new ArrayList<Object>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            list.add(((UIParameter)kid).getValue());
        }
        Object[] args = list.toArray(new Object[0]);
        String text = resources.getMessage(context.getViewRoot().getLocale(), key, args);
        Boolean filter = (Boolean)component.getAttributes().get("filter");
        if (filter == null) {
            filter = Boolean.FALSE;
        }
        if (filter.booleanValue()) {
            return ResponseUtils.filter((String)text);
        }
        return text;
    }
}

