/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.faces.component.JavascriptValidatorComponent;
import org.apache.struts.faces.renderer.AbstractRenderer;
import org.apache.struts.faces.util.StrutsContext;
import org.apache.struts.faces.util.Utils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.Resources;

public class JavascriptValidatorRenderer
extends AbstractRenderer {
    private static final Function<ValidatorAction, Integer> SIZE_VA = va -> va == null || va.getDepends() == null ? 0 : va.getDepends().length();
    private static final Comparator<ValidatorAction> COMP_VA = (va1, va2) -> {
        int size1 = SIZE_VA.apply((ValidatorAction)va1);
        int size2 = SIZE_VA.apply((ValidatorAction)va2);
        if (size1 == 0) {
            return size2 == 0 ? 0 : -1;
        }
        if (size2 == 0) {
            return 1;
        }
        return va1.getDependencyList().size() - va2.getDependencyList().size();
    };
    private static final String HTML_BEGIN_COMMENT = "\n<!-- Begin \n";
    private static final String HTML_END_COMMENT = "//End --> \n";

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Form form;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        StringBuilder results = new StringBuilder();
        StrutsContext strutsContext = new StrutsContext(context);
        JavascriptValidatorComponent jsv = (JavascriptValidatorComponent)component;
        ModuleConfig config = strutsContext.getModuleConfig();
        ValidatorResources resources = Utils.getMapValue(ValidatorResources.class, context.getExternalContext().getApplicationMap(), "org.apache.commons.validator.VALIDATOR_RESOURCES" + config.getPrefix());
        Locale locale = strutsContext.getLocale();
        String bundle = jsv.getBundle();
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((form = resources.getForm(locale, jsv.getFormName())) != null) {
            if (jsv.isDynamicJavascript()) {
                MessageResources messages = Utils.getMapValue(MessageResources.class, context.getExternalContext().getApplicationMap(), bundle);
                ArrayList<ValidatorAction> lActions = new ArrayList<ValidatorAction>();
                ArrayList<String> lActionMethods = new ArrayList<String>();
                for (Field field : form.getFields()) {
                    for (String depends : field.getDependencyList()) {
                        if (depends == null || lActionMethods.contains(depends)) continue;
                        lActionMethods.add(depends);
                    }
                }
                Iterator i = lActionMethods.iterator();
                while (i.hasNext()) {
                    String depends = (String)i.next();
                    ValidatorAction va = resources.getValidatorAction(depends);
                    if (va == null) {
                        throw new NullPointerException("Depends string \"" + (String)depends + "\" was not found in validator-rules.xml.");
                    }
                    String javascript = va.getJavascript();
                    if (javascript != null && javascript.length() > 0) {
                        lActions.add(va);
                        continue;
                    }
                    i.remove();
                }
                Collections.sort(lActions, COMP_VA);
                String methods = null;
                for (ValidatorAction va : lActions) {
                    if (methods == null) {
                        methods = va.getMethod() + "(form)";
                        continue;
                    }
                    methods = methods + " && " + va.getMethod() + "(form)";
                }
                results.append(this.getJavascriptBegin(methods, jsv));
                String formClientId = this.getFormClientId(jsv);
                String formClientIdFunc = formClientId.replace(':', '_');
                for (ValidatorAction va : lActions) {
                    String jscriptVar = null;
                    String functionName = null;
                    functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
                    results.append("    function " + formClientIdFunc + "_" + functionName + " () { \n");
                    for (Field field : form.getFields()) {
                        if (field.isIndexed() || field.getPage() != jsv.getPage() || !field.isDependency(va.getName())) continue;
                        String message = Resources.getMessage((MessageResources)messages, (Locale)locale, (ValidatorAction)va, (Field)field);
                        message = message != null ? message : "";
                        jscriptVar = this.getNextVar(jscriptVar);
                        results.append("     this." + jscriptVar + " = new Array(\"" + formClientId + ":" + field.getKey() + "\", \"" + message + "\", ");
                        results.append("new Function (\"varName\", \"");
                        Map vars = field.getVars();
                        for (Map.Entry entry : vars.entrySet()) {
                            String varName = (String)entry.getKey();
                            Var var = (Var)entry.getValue();
                            String varValue = var.getValue();
                            String jsType = var.getJsType();
                            if (varName.startsWith("field")) continue;
                            if ("int".equalsIgnoreCase(jsType)) {
                                results.append("this." + varName + "=" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "; ");
                                continue;
                            }
                            if ("regexp".equalsIgnoreCase(jsType)) {
                                results.append("this." + varName + "=/" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            if ("string".equalsIgnoreCase(jsType)) {
                                results.append("this." + varName + "='" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                                continue;
                            }
                            if ("mask".equalsIgnoreCase(varName)) {
                                results.append("this." + varName + "=/" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            results.append("this." + varName + "='" + ValidatorUtils.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                        }
                        results.append(" return this[varName];\"));\n");
                    }
                    results.append("    } \n\n");
                }
            } else if (jsv.isStaticJavascript()) {
                results.append(this.getStartElement(jsv));
                if (jsv.isHtmlComment()) {
                    results.append(HTML_BEGIN_COMMENT);
                }
            }
        }
        if (jsv.isStaticJavascript()) {
            results.append(this.getJavascriptStaticMethods(resources));
        }
        if (form != null && (jsv.isDynamicJavascript() || jsv.isStaticJavascript())) {
            results.append(this.getJavascriptEnd(jsv));
        }
        writer.write(results.toString());
    }

    protected String getJavascriptBegin(String methods, JavascriptValidatorComponent component) {
        StringBuilder sb = new StringBuilder();
        String name = component.getFormName().substring(0, 1).toUpperCase() + component.getFormName().substring(1);
        sb.append(this.getStartElement(component));
        if (this.isXhtml((UIComponent)component) && component.isCdata()) {
            sb.append("<![CDATA[\r\n");
        }
        if (!this.isXhtml((UIComponent)component) && component.isHtmlComment()) {
            sb.append(HTML_BEGIN_COMMENT);
        }
        sb.append("\n     var bCancel = false; \n\n");
        if (component.getMethod() == null || component.getMethod().isEmpty()) {
            sb.append("    function validate" + name + "(form) {                                                                   \n");
        } else {
            sb.append("    function " + component.getMethod() + "(form) {                                                                   \n");
        }
        sb.append("        if (bCancel) \n");
        sb.append("      return true; \n");
        sb.append("        else \n");
        if (methods == null || methods.isEmpty()) {
            sb.append("       return true; \n");
        } else {
            sb.append("       return " + methods + "; \n");
        }
        sb.append("   } \n\n");
        return sb.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources resources) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        for (ValidatorAction va : resources.getValidatorActions().values()) {
            String javascript;
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript + "\n");
        }
        return sb.toString();
    }

    protected String getJavascriptEnd(JavascriptValidatorComponent component) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (!this.isXhtml((UIComponent)component) && component.isHtmlComment()) {
            sb.append(HTML_END_COMMENT);
        }
        if (this.isXhtml((UIComponent)component) && component.isCdata()) {
            sb.append("]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    private String getNextVar(String input) {
        if (input == null) {
            return "aa";
        }
        input = input.toLowerCase();
        for (int i = input.length(); i > 0; --i) {
            int pos = i - 1;
            char c = input.charAt(pos);
            if ((c = (char)(c + '\u0001')) <= 'z') {
                if (i == 0) {
                    return c + input.substring(pos, input.length());
                }
                if (i == input.length()) {
                    return input.substring(0, pos) + c;
                }
                return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
            }
            input = this.replaceChar(input, pos, 'a');
        }
        return null;
    }

    private String replaceChar(String input, int pos, char c) {
        if (pos == 0) {
            return c + input.substring(pos, input.length());
        }
        if (pos == input.length()) {
            return input.substring(0, pos) + c;
        }
        return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
    }

    private String getStartElement(JavascriptValidatorComponent component) {
        StringBuilder start = new StringBuilder("<script type=\"text/javascript\"");
        if (!this.isXhtml((UIComponent)component)) {
            start.append(" language=\"Javascript\"");
        }
        if (component.getSrc() != null) {
            start.append(" src=\"" + component.getSrc() + "\"");
        }
        start.append("> \n");
        return start.toString();
    }

    private String getFormClientId(JavascriptValidatorComponent component) {
        String formName = component.getFormName();
        for (JavascriptValidatorComponent current = component; current != null; current = current.getParent()) {
            List kids = current.getChildren();
            for (UIComponent kid : kids) {
                if (!(kid instanceof FormComponent) || !formName.equals(kid.getAttributes().get("beanName"))) continue;
                return kid.getClientId(FacesContext.getCurrentInstance());
            }
        }
        throw new IllegalArgumentException("Cannot find child FormComponent for form '" + formName + "'");
    }
}

