/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Locale;
import org.apache.struts.faces.component.HtmlComponent;
import org.apache.struts.faces.renderer.AbstractRenderer;

public class HtmlRenderer
extends AbstractRenderer {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        HtmlComponent htmlComponent = (HtmlComponent)component;
        Locale currentLocale = this.getCurrentLocale(context, component);
        String lang = currentLocale.getLanguage();
        boolean validLanguage = lang != null && lang.length() > 0;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("html", component);
        if (this.isXhtml(component)) {
            writer.writeAttribute("xmlns", (Object)"http://www.w3.org/1999/xhtml", null);
        }
        if ((htmlComponent.isLocale() || htmlComponent.isXhtml()) && validLanguage) {
            writer.writeAttribute("lang", (Object)lang, null);
        }
        if (htmlComponent.isXhtml() && validLanguage) {
            writer.writeAttribute("xml:lang", (Object)lang, null);
        }
        writer.writeText((Object)"\n", null);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("html");
    }

    protected Locale getCurrentLocale(FacesContext context, UIComponent component) {
        HtmlComponent htmlComponent = (HtmlComponent)component;
        if (!htmlComponent.isLocale()) {
            return context.getExternalContext().getRequestLocale();
        }
        HttpSession session = (HttpSession)context.getExternalContext().getSession(true);
        Locale current = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (current != null) {
            return current;
        }
        current = context.getExternalContext().getRequestLocale();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)current);
        return current;
    }
}

