/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import org.apache.struts.faces.renderer.AbstractRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLinkRenderer
extends AbstractRenderer {
    private static final String TOKEN = "org_apache_struts_faces_renderer_CommandLinkRenderer";
    private final Logger log = LoggerFactory.getLogger(CommandLinkRenderer.class);
    private static String[] passThrough = new String[]{"accesskey", "charset", "dir", "hreflang", "lang", "onblur", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "rel", "rev", "style", "tabindex", "target", "title", "type"};

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered() || this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        UIForm form = null;
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            form = (UIForm)parent;
            break;
        }
        if (form == null) {
            this.log.warn("CommandLinkComponent not nested inside UIForm, ignored");
            return;
        }
        String paramId = TOKEN;
        String value = (String)context.getExternalContext().getRequestParameterMap().get(paramId);
        if (value == null || !value.equals(component.getClientId(context))) {
            this.log.trace("decode({}) --> not active", (Object)component.getId());
            return;
        }
        this.log.trace("decode({}) --> queueEvent()", (Object)component.getId());
        component.queueEvent((FacesEvent)new ActionEvent(component));
    }

    @Override
    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!component.isRendered() || this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        UIForm form = null;
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            form = (UIForm)parent;
            break;
        }
        if (form == null) {
            this.log.warn("CommandLinkComponent not nested inside UIForm, ignored");
            return;
        }
        String formClientId = form.getClientId(context);
        String key = formClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + TOKEN;
        if (context.getExternalContext().getRequestMap().get(key) == null) {
            writer.startElement("input", null);
            writer.writeAttribute("name", (Object)TOKEN, null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("value", (Object)"", null);
            writer.endElement("input");
            context.getExternalContext().getRequestMap().put(key, Boolean.TRUE);
        }
        writer.startElement("a", component);
    }

    @Override
    public void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!component.isRendered() || this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        UIComponent form = null;
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm) && !"org.apache.myfaces.trinidad.Form".equals(parent.getFamily()) && !"oracle.adf.Form".equals(parent.getFamily())) continue;
            form = parent;
            break;
        }
        if (form == null) {
            this.log.warn("CommandLinkComponent not nested inside UIForm, ignored");
            return;
        }
        String formClientId = form.getClientId(context);
        if (component.getId() != null) {
            writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        writer.writeAttribute("href", (Object)"#", null);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderPassThrough(context, component, writer, passThrough);
        StringBuilder sb = new StringBuilder();
        sb.append("document.forms['");
        sb.append(formClientId);
        sb.append("']['");
        sb.append(TOKEN);
        sb.append("'].value='");
        sb.append(component.getClientId(context));
        sb.append("';");
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            sb.append("document.forms['");
            sb.append(formClientId);
            sb.append("']['");
            sb.append((String)kid.getAttributes().get("name"));
            sb.append("'].value='");
            sb.append((String)kid.getAttributes().get("value"));
            sb.append("';");
        }
        sb.append("document.forms['");
        sb.append(formClientId);
        sb.append("'].submit(); return false;");
        writer.writeAttribute("onclick", (Object)sb.toString(), null);
        Object value = component.getAttributes().get("value");
        if (value != null) {
            if (value instanceof String) {
                writer.write((String)value);
            } else {
                writer.write(value.toString());
            }
        }
    }

    @Override
    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!component.isRendered() || this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        writer.endElement("a");
    }
}

