/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynaBeanELResolver
extends ELResolver {
    private final Logger log = LoggerFactory.getLogger(DynaBeanELResolver.class);
    private final boolean readOnly;

    public DynaBeanELResolver() {
        this(false);
    }

    public DynaBeanELResolver(boolean readOnly) {
        this.log.debug("Creating new Dyna-Action-From-ELResolver instance with read-only: '{}'", (Object)readOnly);
        this.readOnly = readOnly;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaBean) {
            this.log.trace("Returning property-type '{}' for DynaBean '{}'", property, base);
            DynaBean dynaBean = (DynaBean)base;
            String key = property.toString();
            DynaProperty dynaProperty = this.getDynaProperty(dynaBean, key);
            if (dynaProperty == null) {
                throw new PropertyNotFoundException(key);
            }
            context.setPropertyResolved(true);
            return dynaProperty.getType();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaBean) {
            this.log.trace("Returning dynamic property '{}' for DynaBean '{}'", property, base);
            DynaBean dynaBean = (DynaBean)base;
            String key = property.toString();
            DynaProperty dynaProperty = this.getDynaProperty(dynaBean, key);
            if (dynaProperty == null) {
                throw new PropertyNotFoundException(key);
            }
            context.setPropertyResolved(true);
            return dynaBean.get(key);
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaBean) {
            this.log.trace("Setting dynamic property '{}' for DynaBean '{}'", property, base);
            DynaBean dynaBean = (DynaBean)base;
            String key = property.toString();
            DynaProperty dynaProperty = this.getDynaProperty(dynaBean, key);
            if (dynaProperty == null) {
                throw new PropertyNotFoundException(key);
            }
            if (this.readOnly) {
                throw new PropertyNotWritableException();
            }
            context.setPropertyResolved(true);
            dynaBean.set(key, value);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DynaBean) {
            this.log.trace("Return ready-only status for dynamic property '{}' for DynaBean '{}'", property, base);
            DynaBean dynaBean = (DynaBean)base;
            String key = property.toString();
            DynaProperty dynaProperty = this.getDynaProperty(dynaBean, key);
            if (dynaProperty == null) {
                throw new PropertyNotFoundException(key);
            }
            context.setPropertyResolved(true);
            return this.readOnly;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base instanceof DynaBean) {
            this.log.trace("Get Feature-Descriptors for DynaBean '{}'", base);
            DynaBean dynaBean = (DynaBean)base;
            DynaProperty[] properties = dynaBean.getDynaClass().getDynaProperties();
            int iMax = properties.length;
            FeatureDescriptor[] descriptors = new FeatureDescriptor[iMax];
            for (int i = 0; i < iMax; ++i) {
                DynaProperty property = properties[i];
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setName(property.getName());
                descriptor.setDisplayName(property.getName());
                descriptor.setExpert(false);
                descriptor.setHidden(false);
                descriptor.setPreferred(true);
                descriptor.setShortDescription(null);
                descriptor.setValue("type", property.getType());
                descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                descriptors[i] = descriptor;
            }
            return Arrays.asList(descriptors).iterator();
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof DynaBean) {
            this.log.trace("Get Common-Property-Type for DynaBean '{}'", base);
            return Object.class;
        }
        return null;
    }

    private DynaProperty getDynaProperty(DynaBean bean, String property) throws PropertyNotFoundException {
        DynaProperty dynaProperty = null;
        try {
            dynaProperty = bean.getDynaClass().getDynaProperty(property);
        }
        catch (IllegalArgumentException e) {
            this.log.trace("Get Dyna-Property '{}'", (Object)property, (Object)e);
        }
        return dynaProperty;
    }
}

