/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.faces.component.FormComponent;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionListenerImpl
implements ActionListener {
    private final Logger log = LoggerFactory.getLogger(ActionListenerImpl.class);
    private final ActionListener oldActionListener;

    public ActionListenerImpl(ActionListener oldActionListener) {
        if (oldActionListener == null) {
            throw new NullPointerException();
        }
        this.oldActionListener = oldActionListener;
        this.log.info("Create ActionListener wrapping instance of type '{}'", (Object)oldActionListener.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        ActionSource source = (ActionSource)component;
        boolean standard = source.isImmediate();
        if (!standard) {
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof UIForm)) continue;
                if (parent instanceof FormComponent) break;
                standard = true;
                break;
            }
        }
        if (standard) {
            this.log.debug("Performing standard handling for event from source component '{}'", (Object)component.getId());
            this.oldActionListener.processAction(event);
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        this.log.debug("Performing Struts form submit for event from source component '{}'", (Object)component.getId());
        try {
            request.setAttribute("org.apache.struts.faces.ACTION_EVENT", (Object)event);
            ModuleUtils.getInstance().selectModule(request, servletContext);
            ModuleConfig moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
            this.log.trace("Assigned to module with prefix '{}'", (Object)moduleConfig.getPrefix());
            RequestProcessor processor = this.getRequestProcessor(moduleConfig, servletContext);
            this.log.trace("Invoking request processor instance {}", (Object)processor);
            processor.process(request, response);
            context.responseComplete();
        }
        catch (Exception e) {
            this.log.error("Exception processing action event {}", (Object)event, (Object)e);
        }
        finally {
            request.removeAttribute("org.apache.struts.faces.ACTION_EVENT");
        }
    }

    protected RequestProcessor getRequestProcessor(ModuleConfig config, ServletContext context) {
        String key = "org.apache.struts.action.REQUEST_PROCESSOR" + config.getPrefix();
        RequestProcessor processor = (RequestProcessor)context.getAttribute(key);
        if (processor == null) {
            try {
                this.log.debug("Instantiating RequestProcessor of class {}", (Object)config.getControllerConfig().getProcessorClass());
                ActionServlet servlet = (ActionServlet)context.getAttribute("org.apache.struts.action.ACTION_SERVLET");
                processor = (RequestProcessor)RequestUtils.applicationInstance((String)config.getControllerConfig().getProcessorClass());
                processor.init(servlet, config);
                context.setAttribute(key, (Object)processor);
            }
            catch (Exception e) {
                this.log.error("Cannot instantiate RequestProcessor of class {}", (Object)config.getControllerConfig().getProcessorClass(), (Object)e);
                IllegalStateException e2 = new IllegalStateException("Cannot initialize RequestProcessor of class " + config.getControllerConfig().getProcessorClass());
                e2.initCause(e);
                throw e2;
            }
        }
        return processor;
    }
}

