/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import com.ahsay.pns.entity.User;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAll(Connection conn) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getOne(Connection conn, long id) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setLong(1, id);
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int idx = 1;
                id = rs.getLong(idx++);
                String clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                User user = new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version);
                return user;
            }
        }
        return null;
    }

    public static User save(Connection conn, User user) throws SQLException {
        User newUser = null;
        newUser = user.getId() == null ? UserRepository.insertUser(conn, user) : UserRepository.updateUser(conn, user);
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static User insertUser(Connection conn, User user) throws SQLException {
        String customerId = user.getCustomerId();
        String clientUserId = user.getClientUserId();
        String username = user.getUsername();
        String email = user.getEmail();
        String phone = user.getPhone();
        String sessionToken = user.getSessionToken();
        String deviceToken = user.getDeviceToken();
        String deviceId = user.getDeviceId();
        String deviceName = user.getDeviceName();
        long accountOrder = user.getAccountOrder();
        int status = user.getStatus();
        String totpToken = user.getTotpToken();
        long totpTokenGenDt = user.getTotpTokenGenDT();
        String platform = user.getPlatform();
        String manufacturer = user.getManufacturer();
        int clientType = user.getClientType();
        String version = user.getVersion();
        String sql = "Insert into user (client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        int idx = 1;
        pstmt.setString(idx++, clientUserId);
        pstmt.setString(idx++, username);
        pstmt.setString(idx++, customerId);
        pstmt.setString(idx++, email);
        pstmt.setString(idx++, phone);
        pstmt.setString(idx++, deviceName);
        pstmt.setString(idx++, sessionToken);
        pstmt.setString(idx++, deviceToken);
        pstmt.setString(idx++, deviceId);
        pstmt.setLong(idx++, accountOrder);
        pstmt.setString(idx++, totpToken);
        pstmt.setLong(idx++, totpTokenGenDt);
        pstmt.setInt(idx++, status);
        pstmt.setString(idx++, platform);
        pstmt.setString(idx++, manufacturer);
        pstmt.setInt(idx++, clientType);
        pstmt.setString(idx++, version);
        int result = pstmt.executeUpdate();
        if (result > 1) {
            try (ResultSet rs = pstmt.getGeneratedKeys();){
                long id = rs.getLong(1);
                User user2 = new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version);
                return user2;
            }
        }
        return null;
    }

    public static User updateUser(Connection conn, User user) throws SQLException {
        long id = user.getId();
        String customerId = user.getCustomerId();
        String clientUserId = user.getClientUserId();
        String username = user.getUsername();
        String email = user.getEmail();
        String phone = user.getPhone();
        String sessionToken = user.getSessionToken();
        String deviceToken = user.getDeviceToken();
        String deviceId = user.getDeviceId();
        String deviceName = user.getDeviceName();
        long accountOrder = user.getAccountOrder();
        int status = user.getStatus();
        String totpToken = user.getTotpToken();
        long totpTokenGenDt = user.getTotpTokenGenDT();
        String platform = user.getPlatform();
        String manufacturer = user.getManufacturer();
        int clientType = user.getClientType();
        String version = user.getVersion();
        String sql = "Update user set client_user_id = ?, username = ?, customer_id = ?, email = ?, phone = ?, device_name = ?, session_token = ?, device_token = ?, device_id = ?, account_order = ?, totp_token = ?, totp_token_gendt = ?, status = ?, platform = ?, manufacturer = ?, client_type = ?, version = ? Where id = ?";
        int idx = 1;
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(idx++, clientUserId);
        pstmt.setString(idx++, username);
        pstmt.setString(idx++, customerId);
        pstmt.setString(idx++, email);
        pstmt.setString(idx++, phone);
        pstmt.setString(idx++, deviceName);
        pstmt.setString(idx++, sessionToken);
        pstmt.setString(idx++, deviceToken);
        pstmt.setString(idx++, deviceId);
        pstmt.setLong(idx++, accountOrder);
        pstmt.setString(idx++, totpToken);
        pstmt.setLong(idx++, totpTokenGenDt);
        pstmt.setInt(idx++, status);
        pstmt.setString(idx++, platform);
        pstmt.setString(idx++, manufacturer);
        pstmt.setInt(idx++, clientType);
        pstmt.setString(idx++, version);
        pstmt.setLong(idx++, id);
        int result = pstmt.executeUpdate();
        if (result >= 1) {
            return user;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findByEmail(Connection conn, String email) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where email = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, email);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> findByClientUserId(Connection conn, String clientUserId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where client_user_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findByDeviceId(Connection conn, String deviceId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where device_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, deviceId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findByDeviceIdOrderByAccountOrder(Connection conn, String deviceId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where device_id = ? Order By account_order";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, deviceId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                String clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findByClientUserIdOrderByAccountOrder(Connection conn, String clientUserId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where client_user_id = ? Order By account_order";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> findByClientUserIdAndStatusOrderByAccountOrder(Connection conn, String clientUserId, int status) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where client_user_id = ? and status = ? Order By account_order";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        pstmt.setInt(2, status);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findByClientUserIdAndCustomerId(Connection conn, String clientUserId, String customerId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where client_user_id = ? and customer_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        pstmt.setString(2, customerId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                String deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> findByClientUserIdAndDeviceId(Connection conn, String clientUserId, String deviceId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where client_user_id = ? and device_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        pstmt.setString(2, deviceId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                String customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<User> findByClientUserIdAndDeviceIdAndCustomerId(Connection conn, String clientUserId, String deviceId, String customerId) throws SQLException {
        String sql = "Select id, client_user_id, username, customer_id, email, phone, device_name, session_token, device_token, device_id, account_order, totp_token, totp_token_gendt, status, platform, manufacturer, client_type, version from user Where client_user_id = ? and device_id = ? and customer_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        pstmt.setString(2, deviceId);
        pstmt.setString(3, customerId);
        ArrayList<User> users = new ArrayList<User>();
        try (ResultSet rs = null;){
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                clientUserId = rs.getString(idx++);
                String username = rs.getString(idx++);
                customerId = rs.getString(idx++);
                String email = rs.getString(idx++);
                String phone = rs.getString(idx++);
                String deviceName = rs.getString(idx++);
                String sessionToken = rs.getString(idx++);
                String deviceToken = rs.getString(idx++);
                deviceId = rs.getString(idx++);
                long accountOrder = rs.getLong(idx++);
                String totpToken = rs.getString(idx++);
                long totpTokenGenDt = rs.getLong(idx++);
                int status = rs.getInt(idx++);
                String platform = rs.getString(idx++);
                String manufacturer = rs.getString(idx++);
                int clientType = rs.getInt(idx++);
                String version = rs.getString(idx++);
                users.add(new User(id, customerId, clientUserId, username, email, phone, sessionToken, deviceToken, deviceId, deviceName, accountOrder, status, totpToken, totpTokenGenDt, platform, manufacturer, clientType, version));
            }
        }
        return users;
    }

    public void deleteByClientUserId(Connection conn, String clientUserId) throws SQLException {
        String sql = "Delete from user where client_user_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        int result = pstmt.executeUpdate();
    }

    public static int deleteByClientUserIdAndDeviceIdAndCustomerId(Connection conn, String clientUserId, String deviceId, String customerId) throws SQLException {
        String sql = "Delete from user where client_user_id = ? and device_id = ? and customer_id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, clientUserId);
        pstmt.setString(2, deviceId);
        pstmt.setString(3, customerId);
        int result = pstmt.executeUpdate();
        return result;
    }
}

