/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.pns.repository;

import com.ahsay.pns.entity.SmsUsage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SmsUsageRepository {
    public static SmsUsage save(Connection conn, SmsUsage smsUsage) throws SQLException {
        SmsUsage newSmsUsage = null;
        newSmsUsage = smsUsage.getId() == null ? SmsUsageRepository.insertSmsUsage(conn, smsUsage) : SmsUsageRepository.updateSmsUsage(conn, smsUsage);
        return newSmsUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SmsUsage insertSmsUsage(Connection conn, SmsUsage smsUsage) throws SQLException {
        String sql = "Insert Into sms_usage (license, username, owner, create_time, ip_addr, phone, result) Values (?, ?, ?, ?, ?, ? ,?)";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, smsUsage.getLicense());
        pstmt.setString(2, smsUsage.getUsername());
        pstmt.setString(3, smsUsage.getOwner());
        pstmt.setLong(4, smsUsage.getCreateTime());
        pstmt.setString(5, smsUsage.getIpAddr());
        pstmt.setString(6, smsUsage.getPhone());
        pstmt.setBoolean(7, smsUsage.getResult());
        int result = pstmt.executeUpdate();
        if (result > 0) {
            ResultSet rs = null;
            try {
                SmsUsage newSmsUsage;
                rs = pstmt.getGeneratedKeys();
                long id = rs.getLong(1);
                SmsUsage smsUsage2 = newSmsUsage = new SmsUsage(id, smsUsage.getLicense(), smsUsage.getUsername(), smsUsage.getOwner(), smsUsage.getCreateTime(), smsUsage.getIpAddr(), smsUsage.getPhone(), smsUsage.getResult());
                return smsUsage2;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                pstmt.close();
            }
        }
        return null;
    }

    private static SmsUsage updateSmsUsage(Connection conn, SmsUsage smsUsage) throws SQLException {
        String sql = "Update sms_usage Set license = ?, username = ?, owner = ?, create_time = ?, ip_addr = ?, phone = ?, result = ? Where id = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, smsUsage.getLicense());
        pstmt.setString(2, smsUsage.getUsername());
        pstmt.setString(3, smsUsage.getOwner());
        pstmt.setLong(4, smsUsage.getCreateTime());
        pstmt.setString(5, smsUsage.getIpAddr());
        pstmt.setString(6, smsUsage.getPhone());
        pstmt.setBoolean(7, smsUsage.getResult());
        pstmt.setLong(7, smsUsage.getId());
        int result = pstmt.executeUpdate();
        if (result > 0) {
            return smsUsage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SmsUsage> findByLicenseAndResult(Connection conn, String license, boolean result) throws SQLException {
        String sql = "Select id, license, username, owner, create_time, ip_addr, phone, result From sms_usage Where license = ? and result = ?";
        ArrayList<SmsUsage> usages = new ArrayList<SmsUsage>();
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setBoolean(2, result);
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                license = rs.getString(idx++);
                String username = rs.getString(idx++);
                String owner = rs.getString(idx++);
                long createTime = rs.getLong(idx++);
                String ipAddr = rs.getString(idx++);
                String phone = rs.getString(idx++);
                result = rs.getBoolean(idx++);
                usages.add(new SmsUsage(id, license, username, owner, createTime, ipAddr, phone, result));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return usages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmsUsage> findByLicenseAndUsernameAndResult(Connection conn, String license, String username, boolean result) throws SQLException {
        String sql = "Select id, license, username, owner, create_time, ip_addr, phone, result From sms_usage Where license = ? and username = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setString(2, username);
        pstmt.setBoolean(3, result);
        ArrayList<SmsUsage> usages = new ArrayList<SmsUsage>();
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                license = rs.getString(idx++);
                username = rs.getString(idx++);
                String owner = rs.getString(idx++);
                long createTime = rs.getLong(idx++);
                String ipAddr = rs.getString(idx++);
                String phone = rs.getString(idx++);
                result = rs.getBoolean(idx++);
                usages.add(new SmsUsage(id, license, username, owner, createTime, ipAddr, phone, result));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return usages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmsUsage> findByLicenseAndOwnerAndResult(Connection conn, String license, String owner, boolean result) throws SQLException {
        String sql = "Select id, license, username, owner, create_time, ip_addr, phone, result From sms_usage Where license = ? and owner = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setString(2, owner);
        pstmt.setBoolean(3, result);
        ArrayList<SmsUsage> usages = new ArrayList<SmsUsage>();
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                license = rs.getString(idx++);
                String username = rs.getString(idx++);
                owner = rs.getString(idx++);
                long createTime = rs.getLong(idx++);
                String ipAddr = rs.getString(idx++);
                String phone = rs.getString(idx++);
                result = rs.getBoolean(idx++);
                usages.add(new SmsUsage(id, license, username, owner, createTime, ipAddr, phone, result));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return usages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmsUsage> findByLicenseAndUsernameAndOwnerAndResult(Connection conn, String license, String username, String owner, boolean result) throws SQLException {
        String sql = "Select id, license, username, owner, create_time, ip_addr, phone, result From sms_usage Where license = ? and username = ? and owner = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setString(2, username);
        pstmt.setString(3, owner);
        pstmt.setBoolean(4, result);
        ArrayList<SmsUsage> usages = new ArrayList<SmsUsage>();
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                long id = rs.getLong(idx++);
                license = rs.getString(idx++);
                username = rs.getString(idx++);
                owner = rs.getString(idx++);
                long createTime = rs.getLong(idx++);
                String ipAddr = rs.getString(idx++);
                String phone = rs.getString(idx++);
                result = rs.getBoolean(idx++);
                usages.add(new SmsUsage(id, license, username, owner, createTime, ipAddr, phone, result));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return usages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count(Connection conn) throws SQLException {
        String sql = "Select Count(*) from sms_usage";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = count = rs.getInt(1);
                return n;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countByLicenseAndResult(Connection conn, String license, boolean result) throws SQLException {
        String sql = "Select Count(*) from sms_usage Where license = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setBoolean(2, result);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = count = rs.getInt(1);
                return n;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countByLicenseAndUsernameAndResult(Connection conn, String license, String username, boolean result) throws SQLException {
        String sql = "Select Count(*) from sms_usage Where license = ? and username = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setString(2, username);
        pstmt.setBoolean(3, result);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
                long l = count;
                return l;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countByLicenseAndOwnerAndResult(Connection conn, String license, String owner, boolean result) throws SQLException {
        String sql = "Select Count(*) from sms_usage Where license = ? and owner = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setString(2, owner);
        pstmt.setBoolean(3, result);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
                long l = count;
                return l;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countByLicenseAndUsernameAndOwnerAndResult(Connection conn, String license, String username, String owner, boolean result) throws SQLException {
        String sql = "Select Count(*) from sms_usage Where license = ? and username =? and owner = ? and result = ?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, license);
        pstmt.setString(2, username);
        pstmt.setString(3, owner);
        pstmt.setBoolean(4, result);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
                long l = count;
                return l;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> countByDateInterval(Connection conn, String startDate, String endDate) throws SQLException {
        String sql = "SELECT license, owner, COUNT(*) FROM SmsUsage WHERE DATE(createTime/1000, 'unixepoch') BETWEEN ? And ? GROUP BY license, owner ORDER BY license, owner ASC";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, startDate);
        pstmt.setString(2, endDate);
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                String license = rs.getString(idx++);
                String owner = rs.getString(idx++);
                int count = rs.getInt(idx++);
                objects.add(new Object[]{license, owner, count});
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> countByDateIntervalGroupByDate(Connection conn, String startDate, String endDate) throws SQLException {
        String sql = "SELECT license, owner, DATE(create_time/1000, 'unixepoch'), COUNT(*) FROM sms_usage WHERE DATE(create_time/1000, 'unixepoch') BETWEEN ? And ? GROUP BY license, owner, DATE(create_time/1000, 'unixepoch') ORDER BY license, owner ASC";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        pstmt.setString(1, startDate);
        pstmt.setString(2, endDate);
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        ResultSet rs = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int idx = 1;
                String license = rs.getString(idx++);
                String owner = rs.getString(idx++);
                int count = rs.getInt(idx++);
                objects.add(new Object[]{license, owner, count});
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            pstmt.close();
        }
        return objects;
    }
}

