/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.definition.ComponentDefinitionsFactoryWrapper;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesUtilImpl
implements Serializable {
    private static final long serialVersionUID = -3811960942326759160L;
    private static final Logger LOG = LoggerFactory.getLogger(TilesUtilImpl.class);
    private final transient Logger log = LoggerFactory.getLogger(TilesUtilImpl.class);
    public static final String DEFINITIONS_FACTORY = "org.apache.struts.tiles.DEFINITIONS_FACTORY";
    private static Method include = null;

    public void doForward(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        request.getRequestDispatcher(uri).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doInclude(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        request.getRequestDispatcher(uri).include((ServletRequest)request, (ServletResponse)response);
    }

    public void doInclude(String uri, PageContext pageContext, boolean flush) throws IOException, ServletException {
        try {
            if (include != null) {
                include.invoke((Object)pageContext, uri, flush);
                return;
            }
        }
        catch (IllegalAccessException e) {
            this.log.debug("Could not find JSP 2.0 include method.  Using old one.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ServletException) {
                throw (ServletException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new ServletException((Throwable)e);
        }
        pageContext.include(uri);
    }

    public DefinitionsFactory getDefinitionsFactory(ServletRequest request, ServletContext servletContext) {
        return (DefinitionsFactory)servletContext.getAttribute(DEFINITIONS_FACTORY);
    }

    public DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, DefinitionsFactoryConfig factoryConfig) throws DefinitionsFactoryException {
        DefinitionsFactory factory = this.createDefinitionFactoryInstance(factoryConfig.getFactoryClassname());
        factory.init(factoryConfig, servletContext);
        this.makeDefinitionsFactoryAccessible(factory, servletContext);
        return factory;
    }

    protected DefinitionsFactory createDefinitionFactoryInstance(String classname) throws DefinitionsFactoryException {
        try {
            Class factoryClass = RequestUtils.applicationClass((String)classname);
            Object factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (factory instanceof ComponentDefinitionsFactory) {
                factory = new ComponentDefinitionsFactoryWrapper((ComponentDefinitionsFactory)factory);
            }
            return (DefinitionsFactory)factory;
        }
        catch (ClassCastException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + classname + " must implement 'TilesDefinitionsFactory'.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + classname + "'.", ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new DefinitionsFactoryException(ex);
        }
    }

    protected void makeDefinitionsFactoryAccessible(DefinitionsFactory factory, ServletContext servletContext) {
        servletContext.setAttribute(DEFINITIONS_FACTORY, (Object)factory);
    }

    static {
        try {
            include = PageContext.class.getMethod("include", String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Could not find JSP 2.0 include method.  Using old one that doesn't support configurable flushing.", (Throwable)e);
        }
    }
}

