/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.TilesUtilImpl;

public class TilesUtil {
    protected static TilesUtilImpl tilesUtilImpl = new TilesUtilImpl();
    private static boolean implAlreadySet = false;

    public static TilesUtilImpl getTilesUtil() {
        return tilesUtilImpl;
    }

    public static void setTilesUtil(TilesUtilImpl tilesUtil) {
        if (implAlreadySet) {
            return;
        }
        tilesUtilImpl = tilesUtil;
        implAlreadySet = true;
    }

    static boolean isTilesUtilImplSet() {
        return implAlreadySet;
    }

    public static void doForward(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        tilesUtilImpl.doForward(uri, request, response, servletContext);
    }

    public static void doInclude(String uri, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException, ServletException {
        tilesUtilImpl.doInclude(uri, request, response, servletContext);
    }

    public static void doInclude(String uri, PageContext pageContext) throws IOException, ServletException {
        TilesUtil.doInclude(uri, pageContext, true);
    }

    public static void doInclude(String uri, PageContext pageContext, boolean flush) throws IOException, ServletException {
        tilesUtilImpl.doInclude(uri, pageContext, flush);
    }

    public static DefinitionsFactory getDefinitionsFactory(ServletRequest request, ServletContext servletContext) {
        return tilesUtilImpl.getDefinitionsFactory(request, servletContext);
    }

    public static DefinitionsFactory createDefinitionsFactory(ServletContext servletContext, DefinitionsFactoryConfig factoryConfig) throws DefinitionsFactoryException {
        return tilesUtilImpl.createDefinitionsFactory(servletContext, factoryConfig);
    }

    public static ComponentDefinition getDefinition(String definitionName, ServletRequest request, ServletContext servletContext) throws FactoryNotFoundException, DefinitionsFactoryException {
        try {
            return TilesUtil.getDefinitionsFactory(request, servletContext).getDefinition(definitionName, (ServletRequest)((HttpServletRequest)request), servletContext);
        }
        catch (NullPointerException ex) {
            throw new FactoryNotFoundException("Can't get definitions factory from context.");
        }
    }

    protected static void testReset() {
        implAlreadySet = false;
        tilesUtilImpl = new TilesUtilImpl();
    }
}

