/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import java.util.Map;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.chain.ComposableRequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.tiles.TilesUtil;
import org.apache.struts.tiles.TilesUtilStrutsImpl;
import org.apache.struts.tiles.TilesUtilStrutsModulesImpl;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TilesPlugin
implements PlugIn {
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private final Logger log = LoggerFactory.getLogger(TilesPlugin.class);
    protected boolean moduleAware = false;
    protected String tilesUtilImplClassname = null;
    protected DefinitionsFactory definitionFactory = null;
    protected PlugInConfig currentPlugInConfigObject = null;

    public boolean isModuleAware() {
        return this.moduleAware;
    }

    public void setModuleAware(boolean moduleAware) {
        this.moduleAware = moduleAware;
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        DefinitionsFactoryConfig factoryConfig = this.readFactoryConfig(servlet, moduleConfig);
        factoryConfig.setFactoryName(moduleConfig.getPrefix());
        this.initRequestProcessorClass(moduleConfig);
        this.initTilesUtil();
        this.initDefinitionsFactory(servlet.getServletContext(), moduleConfig, factoryConfig);
    }

    private void initTilesUtil() throws ServletException {
        if (TilesUtil.isTilesUtilImplSet()) {
            this.log.debug("Skipping re-init of Tiles Plugin. Values defined in the first initialized plugin take precedence.");
            return;
        }
        if (this.getTilesUtilImplClassname() == null) {
            if (this.isModuleAware()) {
                TilesUtil.setTilesUtil(new TilesUtilStrutsModulesImpl());
            } else {
                TilesUtil.setTilesUtil(new TilesUtilStrutsImpl());
            }
        } else {
            try {
                TilesUtilStrutsImpl impl = (TilesUtilStrutsImpl)RequestUtils.applicationClass((String)this.getTilesUtilImplClassname()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                TilesUtil.setTilesUtil(impl);
            }
            catch (ClassCastException ex) {
                throw new ServletException("Can't set TilesUtil implementation to '" + this.getTilesUtilImplClassname() + "'. TilesUtil implementation should be a subclass of '" + TilesUtilStrutsImpl.class.getName() + "'", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new ServletException("Can't set TilesUtil implementation.", (Throwable)ex);
            }
        }
    }

    private void initDefinitionsFactory(ServletContext servletContext, ModuleConfig moduleConfig, DefinitionsFactoryConfig factoryConfig) throws ServletException {
        this.definitionFactory = ((TilesUtilStrutsImpl)TilesUtil.getTilesUtil()).getDefinitionsFactory(servletContext, moduleConfig);
        if (this.definitionFactory != null) {
            throw new UnavailableException("Factory already exists for module '" + moduleConfig.getPrefix() + "' and cannot be redefined. The factory found is from module '" + this.definitionFactory.getConfig().getFactoryName() + "'.");
        }
        try {
            this.definitionFactory = TilesUtil.createDefinitionsFactory(servletContext, factoryConfig);
        }
        catch (DefinitionsFactoryException ex) {
            this.log.error("Can't create Tiles definition factory for module '{}'.", (Object)moduleConfig.getPrefix());
            throw new ServletException((Throwable)ex);
        }
        this.log.info("Tiles definition factory loaded for module '{}'.", (Object)moduleConfig.getPrefix());
    }

    public void destroy() {
        this.definitionFactory.destroy();
        this.definitionFactory = null;
    }

    protected DefinitionsFactoryConfig readFactoryConfig(ActionServlet servlet, ModuleConfig config) throws ServletException {
        DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
        try {
            DefinitionsUtil.populateDefinitionsFactoryConfig(factoryConfig, servlet.getServletConfig());
        }
        catch (Exception ex) {
            String message = "Can't populate DefinitionsFactoryConfig class from 'web.xml'";
            this.log.debug(message, (Throwable)ex);
            ex.printStackTrace();
            UnavailableException e2 = new UnavailableException(message);
            e2.initCause((Throwable)ex);
            throw e2;
        }
        try {
            Map<String, Object> strutsProperties = this.findStrutsPlugInConfigProperties(servlet, config);
            factoryConfig.populate(strutsProperties);
        }
        catch (Exception ex) {
            String message = "Can't populate DefinitionsFactoryConfig class from '" + config.getPrefix() + "/struts-config.xml'";
            this.log.debug(message, (Throwable)ex);
            UnavailableException e2 = new UnavailableException(message);
            e2.initCause((Throwable)ex);
            throw e2;
        }
        return factoryConfig;
    }

    protected Map<String, Object> findStrutsPlugInConfigProperties(ActionServlet servlet, ModuleConfig config) throws ServletException {
        return this.currentPlugInConfigObject.getProperties();
    }

    protected void initRequestProcessorClass(ModuleConfig config) throws ServletException {
        Class configProcessorClass;
        String tilesProcessorClassname = TilesRequestProcessor.class.getName();
        ControllerConfig ctrlConfig = config.getControllerConfig();
        String configProcessorClassname = ctrlConfig.getProcessorClass();
        try {
            configProcessorClass = RequestUtils.applicationClass((String)configProcessorClassname);
        }
        catch (ClassNotFoundException ex) {
            this.log.error(FATAL, "Can't set TilesRequestProcessor: bad class name '{}'.", (Object)configProcessorClassname);
            throw new ServletException((Throwable)ex);
        }
        if (ComposableRequestProcessor.class.isAssignableFrom(configProcessorClass)) {
            return;
        }
        if (configProcessorClassname.equals(RequestProcessor.class.getName()) || configProcessorClassname.endsWith(tilesProcessorClassname)) {
            ctrlConfig.setProcessorClass(tilesProcessorClassname);
            return;
        }
        Class<TilesRequestProcessor> tilesProcessorClass = TilesRequestProcessor.class;
        if (!tilesProcessorClass.isAssignableFrom(configProcessorClass)) {
            String msg = "TilesPlugin : Specified RequestProcessor not compatible with TilesRequestProcessor";
            this.log.error(FATAL, msg);
            throw new ServletException(msg);
        }
    }

    public void setTilesUtilImplClassname(String tilesUtilImplClassname) {
        this.tilesUtilImplClassname = tilesUtilImplClassname;
    }

    public String getTilesUtilImplClassname() {
        return this.tilesUtilImplClassname;
    }

    public void setCurrentPlugInConfigObject(PlugInConfig plugInConfigObject) {
        this.currentPlugInConfigObject = plugInConfigObject;
    }
}

