/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2StringUtil;
import java.io.IOException;
import java.io.OutputStream;

public class B2Utf8Util {
    public static void write(String str, OutputStream out) throws IOException {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            i = B2Utf8Util.doCommonWrite(str, i, c, out);
        }
    }

    public static void writeJsonString(CharSequence value, OutputStream out) throws IOException {
        out.write(34);
        int strLen = value.length();
        for (int i = 0; i < strLen; ++i) {
            char c = value.charAt(i);
            if (c < ' ') {
                out.write(92);
                out.write(117);
                out.write(48);
                out.write(48);
                out.write(B2StringUtil.LOWER_HEX_DIGITS[c / 16]);
                out.write(B2StringUtil.LOWER_HEX_DIGITS[c % 16]);
                continue;
            }
            if (c == '\"') {
                out.write(92);
                out.write(34);
                continue;
            }
            if (c == '\\') {
                out.write(92);
                out.write(92);
                continue;
            }
            i = B2Utf8Util.doCommonWrite(value, i, c, out);
        }
        out.write(34);
    }

    private static int doCommonWrite(CharSequence value, int currentIndex, char c, OutputStream out) throws IOException {
        int currentIndexOut = currentIndex;
        if (c < '\u0080') {
            out.write(c);
        } else if (c < '\u0800') {
            out.write(0xC0 | c >> 6);
            out.write(0x80 | c & 0x3F);
        } else if (Character.isSurrogate(c)) {
            if (++currentIndexOut >= value.length()) {
                throw new IOException("bad surrogate pair: truncated");
            }
            char low = value.charAt(currentIndexOut);
            if (!Character.isSurrogatePair(c, low)) {
                throw new IOException("bad surrogate pair");
            }
            int cp = Character.toCodePoint(c, low);
            out.write(0xF0 | cp >> 18);
            out.write(0x80 | cp >> 12 & 0x3F);
            out.write(0x80 | cp >> 6 & 0x3F);
            out.write(0x80 | cp & 0x3F);
        } else {
            out.write(0xE0 | c >> 12);
            out.write(0x80 | c >> 6 & 0x3F);
            out.write(0x80 | c & 0x3F);
        }
        return currentIndexOut;
    }
}

