/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class B2IoUtils {
    private static final int EOF = -1;

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return B2IoUtils.copyGuts(in, out, new byte[4096]);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static long copyGuts(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void readToEnd(InputStream in) throws IOException {
        B2IoUtils.readToEnd(in, new byte[4096]);
    }

    private static void readToEnd(InputStream in, byte[] scratchBuffer) throws IOException {
        while (in.read(scratchBuffer) != -1) {
        }
    }
}

